/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.metric;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;

class ParameterValidator {
    ParameterValidator() {
    }

    void validate(List<String> requiredKeys, List<String> requiredNonEmptyKeys, List<String> requiredNonNullKeys, Map<String, Object> data) {
        requiredKeys.forEach(key -> Preconditions.checkState((boolean)data.containsKey(key), (Object)(key + " need to be assigned")));
        requiredNonEmptyKeys.forEach(key -> {
            String value = (String)data.get(key);
            Preconditions.checkNotNull((Object)value, (Object)(key + " cannot be null"));
            Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)(key + " cannot be an empty string"));
        });
        requiredNonNullKeys.forEach(key -> {
            Object value = data.get(key);
            Preconditions.checkNotNull(value, (Object)(key + " cannot be null"));
        });
    }
}

