/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.typeconverter;

import org.opensearch.dataprepper.typeconverter.TypeConverter;

public class BooleanConverter
implements TypeConverter<Boolean> {
    @Override
    public Boolean convert(Object source) throws IllegalArgumentException {
        if (source instanceof String) {
            return Boolean.parseBoolean((String)source);
        }
        if (source instanceof Number) {
            Number number = (Number)source;
            return number.intValue() != 0 || number.longValue() != 0L || number.floatValue() != 0.0f || number.doubleValue() != 0.0 || number.shortValue() != 0 || number.byteValue() != 0;
        }
        if (source instanceof Boolean) {
            return (Boolean)source;
        }
        throw new IllegalArgumentException("Unsupported type conversion");
    }
}

