/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.source.coordinator;

import java.util.Objects;
import java.util.Optional;

public class SourcePartition<T> {
    private final String partitionKey;
    private final T partitionState;

    private SourcePartition(Builder<T> builder) {
        Objects.requireNonNull(builder.partitionKey);
        this.partitionKey = builder.partitionKey;
        this.partitionState = builder.partitionState;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public Optional<T> getPartitionState() {
        return Optional.ofNullable(this.partitionState);
    }

    public static <T> Builder<T> builder(Class<T> clazz) {
        return new Builder<T>(clazz);
    }

    public static class Builder<T> {
        private String partitionKey;
        private T partitionState;

        public Builder(Class<T> clazz) {
        }

        public Builder<T> withPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public Builder<T> withPartitionState(T partitionState) {
            this.partitionState = partitionState;
            return this;
        }

        public SourcePartition<T> build() {
            return new SourcePartition(this);
        }
    }
}

