/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.event;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.opensearch.dataprepper.model.event.InternalEventHandle;

abstract class AbstractEventHandle
implements EventHandle,
InternalEventHandle {
    private Instant externalOriginationTime = null;
    private final Instant internalOriginationTime;
    private List<BiConsumer<EventHandle, Boolean>> releaseConsumers;

    AbstractEventHandle(Instant internalOriginationTime) {
        this.internalOriginationTime = internalOriginationTime;
        this.releaseConsumers = new ArrayList<BiConsumer<EventHandle, Boolean>>();
    }

    @Override
    public void setExternalOriginationTime(Instant externalOriginationTime) {
        this.externalOriginationTime = externalOriginationTime;
    }

    @Override
    public Instant getInternalOriginationTime() {
        return this.internalOriginationTime;
    }

    @Override
    public Instant getExternalOriginationTime() {
        return this.externalOriginationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRelease(BiConsumer<EventHandle, Boolean> releaseConsumer) {
        List<BiConsumer<EventHandle, Boolean>> list = this.releaseConsumers;
        synchronized (list) {
            this.releaseConsumers.add(releaseConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyReleaseConsumers(boolean result) {
        List<BiConsumer<EventHandle, Boolean>> list = this.releaseConsumers;
        synchronized (list) {
            for (BiConsumer<EventHandle, Boolean> consumer : this.releaseConsumers) {
                consumer.accept(this, result);
            }
        }
    }
}

