/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.sink;

import org.opensearch.dataprepper.model.sink.AbstractSink;

class SinkThread
implements Runnable {
    private final AbstractSink sink;
    private int maxRetries;
    private int waitTimeMs;
    private volatile boolean isStopped = false;

    public SinkThread(AbstractSink sink, int maxRetries, int waitTimeMs) {
        this.sink = sink;
        this.maxRetries = maxRetries;
        this.waitTimeMs = waitTimeMs;
    }

    @Override
    public void run() {
        int numRetries = 0;
        while (!this.sink.isReady() && numRetries++ < this.maxRetries && !this.isStopped) {
            try {
                Thread.sleep(this.waitTimeMs);
                this.sink.doInitialize();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stop() {
        this.isStopped = true;
    }
}

