/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.metric;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.opensearch.dataprepper.model.event.EventType;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.metric.DefaultExemplar;
import org.opensearch.dataprepper.model.metric.Exemplar;
import org.opensearch.dataprepper.model.metric.Metric;

public abstract class JacksonMetric
extends JacksonEvent
implements Metric {
    protected static final String NAME_KEY = "name";
    protected static final String SCOPE_KEY = "instrumentationScope";
    protected static final String RESOURCE_KEY = "resource";
    protected static final String DESCRIPTION_KEY = "description";
    protected static final String START_TIME_KEY = "startTime";
    protected static final String TIME_KEY = "time";
    protected static final String SERVICE_NAME_KEY = "serviceName";
    protected static final String KIND_KEY = "kind";
    protected static final String UNIT_KEY = "unit";
    public static final String ATTRIBUTES_KEY = "attributes";
    protected static final String SCHEMA_URL_KEY = "schemaUrl";
    protected static final String EXEMPLARS_KEY = "exemplars";
    protected static final String FLAGS_KEY = "flags";
    protected static final String METADATA_KEY = "metadata";
    private boolean flattenAttributes;

    protected JacksonMetric(Builder builder, boolean flattenAttributes) {
        super(builder);
        this.flattenAttributes = flattenAttributes;
    }

    public void setFlattenAttributes(boolean flattenAttributes) {
        this.flattenAttributes = flattenAttributes;
    }

    boolean getFlattenAttributes() {
        return this.flattenAttributes;
    }

    protected void checkAndSetDefaultValues() {
        this.putIfAbsent(ATTRIBUTES_KEY, Map.class, new HashMap());
    }

    @Override
    public String toJsonString() {
        if (!this.flattenAttributes) {
            return this.getJsonNode().toString();
        }
        ObjectNode attributesNode = (ObjectNode)this.getJsonNode().get(ATTRIBUTES_KEY);
        ObjectNode flattenedJsonNode = (ObjectNode)this.getJsonNode().deepCopy();
        if (attributesNode != null) {
            flattenedJsonNode.remove(ATTRIBUTES_KEY);
            Iterator it = attributesNode.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String field = (String)entry.getKey();
                if (flattenedJsonNode.has(field)) continue;
                flattenedJsonNode.set(field, (JsonNode)entry.getValue());
            }
        }
        return flattenedJsonNode.toString();
    }

    @Override
    public String getServiceName() {
        return this.get(SERVICE_NAME_KEY, String.class);
    }

    @Override
    public String getName() {
        return this.get(NAME_KEY, String.class);
    }

    @Override
    public String getDescription() {
        return this.get(DESCRIPTION_KEY, String.class);
    }

    @Override
    public String getUnit() {
        return this.get(UNIT_KEY, String.class);
    }

    @Override
    public String getKind() {
        return this.get(KIND_KEY, String.class);
    }

    @Override
    public Map<String, Object> getMetricMetadata() {
        return this.get(METADATA_KEY, Map.class);
    }

    @Override
    public String getStartTime() {
        return this.get(START_TIME_KEY, String.class);
    }

    @Override
    public Map<String, Object> getScope() {
        return this.get(SCOPE_KEY, Map.class);
    }

    @Override
    public Map<String, Object> getResource() {
        return this.get(RESOURCE_KEY, Map.class);
    }

    @Override
    public String getTime() {
        return this.get(TIME_KEY, String.class);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.get(ATTRIBUTES_KEY, Map.class);
    }

    @Override
    public String getSchemaUrl() {
        return this.get(SCHEMA_URL_KEY, String.class);
    }

    @Override
    public List<? extends Exemplar> getExemplars() {
        return this.getList(EXEMPLARS_KEY, DefaultExemplar.class);
    }

    @Override
    public Integer getFlags() {
        return this.get(FLAGS_KEY, Integer.class);
    }

    public static abstract class Builder<T extends JacksonEvent.Builder<T>>
    extends JacksonEvent.Builder<T> {
        private final Map<String, Object> mdata;

        public Builder() {
            if (this.data == null) {
                this.data = new HashMap();
            }
            this.mdata = (HashMap)this.data;
            this.eventHandle = null;
        }

        public void put(String key, Object value) {
            this.mdata.put(key, value);
        }

        public T withEventKind(String kind) {
            this.put(JacksonMetric.KIND_KEY, kind);
            return this.getThis();
        }

        public T withUnit(String unit) {
            this.put(JacksonMetric.UNIT_KEY, unit);
            return this.getThis();
        }

        public T withEventHandle(EventHandle eventHandle) {
            this.eventHandle = eventHandle;
            return this.getThis();
        }

        public T withAttributes(Map<String, Object> attributes) {
            this.put(JacksonMetric.ATTRIBUTES_KEY, attributes);
            return this.getThis();
        }

        public T withName(String name) {
            this.put(JacksonMetric.NAME_KEY, name);
            return this.getThis();
        }

        public T withDescription(String description) {
            this.put(JacksonMetric.DESCRIPTION_KEY, description);
            return this.getThis();
        }

        public T withStartTime(String startTime) {
            this.put(JacksonMetric.START_TIME_KEY, startTime);
            return this.getThis();
        }

        public T withTime(String time) {
            this.put(JacksonMetric.TIME_KEY, time);
            return this.getThis();
        }

        public T withServiceName(String serviceName) {
            this.put(JacksonMetric.SERVICE_NAME_KEY, serviceName);
            return this.getThis();
        }

        public T withScope(Map<String, Object> scope) {
            this.put(JacksonMetric.SCOPE_KEY, scope);
            return this.getThis();
        }

        public T withMetricMetadata(Map<String, Object> metadata) {
            this.put(JacksonMetric.METADATA_KEY, metadata);
            return this.getThis();
        }

        public T withResource(Map<String, Object> resource) {
            this.put(JacksonMetric.RESOURCE_KEY, resource);
            return this.getThis();
        }

        public T withSchemaUrl(String schemaUrl) {
            this.put(JacksonMetric.SCHEMA_URL_KEY, schemaUrl);
            return this.getThis();
        }

        public T withTimeReceived(Instant timeReceived) {
            return (T)super.withTimeReceived(timeReceived);
        }

        public T withExemplars(List<Exemplar> exemplars) {
            this.put(JacksonMetric.EXEMPLARS_KEY, exemplars);
            return this.getThis();
        }

        public T withFlags(Integer flags) {
            this.put(JacksonMetric.FLAGS_KEY, flags);
            return this.getThis();
        }

        protected void populateEvent(String kind) {
            this.withData(this.data);
            this.withEventKind(kind);
            this.withEventType(EventType.METRIC.toString());
        }
    }
}

