/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.event;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.dataprepper.model.event.EventMetadata;

public class DefaultEventMetadata
implements EventMetadata {
    @JsonProperty(value="event_type")
    private String eventType;
    @JsonProperty(value="time_received")
    private Instant timeReceived;
    @JsonProperty(value="external_origination_time")
    private Instant externalOriginationTime;
    @JsonProperty(value="attributes")
    private Map<String, Object> attributes;
    @JsonProperty(value="tags")
    private Set<String> tags;

    private DefaultEventMetadata() {
    }

    private DefaultEventMetadata(Builder builder) {
        Preconditions.checkNotNull((Object)builder.eventType, (Object)"eventType cannot be null");
        Preconditions.checkArgument((!builder.eventType.isEmpty() ? 1 : 0) != 0, (Object)"eventType cannot be empty");
        this.eventType = builder.eventType;
        this.timeReceived = builder.timeReceived == null ? Instant.now() : builder.timeReceived;
        this.attributes = builder.attributes == null ? new HashMap<String, Object>() : new HashMap<String, Object>(builder.attributes);
        this.tags = builder.tags == null ? new HashSet<String>() : new HashSet<String>(builder.tags);
        this.externalOriginationTime = builder.externalOriginationTime;
    }

    private DefaultEventMetadata(EventMetadata eventMetadata) {
        this.eventType = eventMetadata.getEventType();
        this.timeReceived = eventMetadata.getTimeReceived();
        this.attributes = new HashMap<String, Object>(eventMetadata.getAttributes());
        this.tags = new HashSet<String>(eventMetadata.getTags());
        this.externalOriginationTime = null;
    }

    @Override
    public String getEventType() {
        return this.eventType;
    }

    @Override
    public Instant getTimeReceived() {
        return this.timeReceived;
    }

    @Override
    public Instant getExternalOriginationTime() {
        return this.externalOriginationTime;
    }

    @Override
    public void setExternalOriginationTime(Instant externalOriginationTime) {
        this.externalOriginationTime = externalOriginationTime;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public Object getAttribute(String attributeKey) {
        String key = attributeKey.charAt(0) == '/' ? attributeKey.substring(1) : attributeKey;
        Map mapObject = this.attributes;
        if (key.contains("/")) {
            String[] keys = key.split("/");
            for (int i = 0; i < keys.length - 1; ++i) {
                Object value = mapObject.get(keys[i]);
                if (value == null || !(value instanceof Map)) {
                    return null;
                }
                mapObject = (Map)value;
                key = keys[i + 1];
            }
        }
        return mapObject.get(key);
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    public Boolean hasTags(List<String> tagsList) {
        for (String tag : tagsList) {
            if (this.tags.contains(tag)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addTags(List<String> newTags) {
        if (Objects.nonNull(newTags)) {
            this.tags.addAll(newTags);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultEventMetadata that = (DefaultEventMetadata)o;
        return Objects.equals(this.eventType, that.eventType) && Objects.equals(this.timeReceived, that.timeReceived) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.tags, that.tags);
    }

    public int hashCode() {
        return Objects.hash(this.eventType, this.timeReceived, this.attributes);
    }

    public String toString() {
        return "DefaultEventMetadata{eventType='" + this.eventType + "', timeReceived=" + String.valueOf(this.timeReceived) + ", attributes=" + String.valueOf(this.attributes) + ", tags=" + String.valueOf(this.tags) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    static EventMetadata fromEventMetadata(EventMetadata eventMetadata) {
        return new DefaultEventMetadata(eventMetadata);
    }

    public static class Builder {
        private String eventType;
        private Instant timeReceived;
        private Instant externalOriginationTime;
        private Map<String, Object> attributes;
        private Set<String> tags;

        public Builder withEventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder withTimeReceived(Instant timeReceived) {
            this.timeReceived = timeReceived;
            return this;
        }

        public Builder withExternalOriginationTime(Instant externalOriginationTime) {
            this.externalOriginationTime = externalOriginationTime;
            return this;
        }

        public Builder withAttributes(Map<String, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder withTags(Set<String> tags) {
            this.tags = tags;
            return this;
        }

        public DefaultEventMetadata build() {
            return new DefaultEventMetadata(this);
        }
    }
}

