/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.codec;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.opensearch.dataprepper.model.codec.ByteDecoder;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.log.JacksonLog;
import org.opensearch.dataprepper.model.record.Record;

public class JsonDecoder
implements ByteDecoder {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final JsonFactory jsonFactory = new JsonFactory();
    private String keyName;
    private Collection<String> includeKeys;
    private Collection<String> includeKeysMetadata;

    public JsonDecoder(String keyName, Collection<String> includeKeys, Collection<String> includeKeysMetadata, Integer maxEventLength) {
        this.keyName = keyName;
        this.includeKeys = includeKeys;
        this.includeKeysMetadata = includeKeysMetadata;
        if (maxEventLength != null) {
            this.jsonFactory.setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(maxEventLength.intValue()).build());
        }
    }

    public JsonDecoder() {
        this.keyName = null;
        this.includeKeys = null;
        this.includeKeysMetadata = null;
    }

    @Override
    public void parse(InputStream inputStream, Instant timeReceived, Consumer<Record<Event>> eventConsumer) throws IOException {
        Objects.requireNonNull(inputStream);
        Objects.requireNonNull(eventConsumer);
        JsonParser jsonParser = this.jsonFactory.createParser(inputStream);
        HashMap<String, Object> includeKeysMap = new HashMap<String, Object>();
        HashMap<String, Object> includeMetadataKeysMap = new HashMap<String, Object>();
        while (!jsonParser.isClosed() && jsonParser.nextToken() != JsonToken.END_OBJECT) {
            String nodeName = jsonParser.currentName();
            if (this.includeKeys != null && this.includeKeys.contains(nodeName) || this.includeKeysMetadata != null && this.includeKeysMetadata.contains(nodeName)) {
                jsonParser.nextToken();
                if (this.includeKeys != null && this.includeKeys.contains(nodeName)) {
                    includeKeysMap.put(nodeName, jsonParser.getValueAsString());
                }
                if (this.includeKeysMetadata == null || !this.includeKeysMetadata.contains(nodeName)) continue;
                includeMetadataKeysMap.put(nodeName, jsonParser.getValueAsString());
                continue;
            }
            if (jsonParser.getCurrentToken() != JsonToken.START_ARRAY || this.keyName != null && !this.keyName.equals(nodeName)) continue;
            this.parseRecordsArray(jsonParser, timeReceived, eventConsumer, includeKeysMap, includeMetadataKeysMap);
        }
    }

    private void parseRecordsArray(JsonParser jsonParser, Instant timeReceived, Consumer<Record<Event>> eventConsumer, Map<String, Object> includeKeysMap, Map<String, Object> includeMetadataKeysMap) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            Map innerJson = (Map)this.objectMapper.readValue(jsonParser, Map.class);
            Record<Event> record = this.createRecord(innerJson, timeReceived);
            for (Map.Entry<String, Object> entry : includeKeysMap.entrySet()) {
                record.getData().put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : includeMetadataKeysMap.entrySet()) {
                record.getData().getMetadata().setAttribute(entry.getKey(), entry.getValue());
            }
            eventConsumer.accept(record);
        }
    }

    private Record<Event> createRecord(Map<String, Object> json, Instant timeReceived) {
        JacksonLog.Builder logBuilder = (JacksonLog.Builder)JacksonLog.builder().withData(json).getThis();
        if (timeReceived != null) {
            logBuilder.withTimeReceived(timeReceived);
        }
        JacksonLog event = logBuilder.build();
        return new Record<Event>(event);
    }
}

