/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.source.coordinator.enhanced;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnhancedSourcePartition<T>
implements EnhancedPartition<T> {
    private static final Logger LOG = LoggerFactory.getLogger(EnhancedSourcePartition.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private SourcePartitionStoreItem sourcePartitionStoreItem;

    public SourcePartitionStoreItem getSourcePartitionStoreItem() {
        return this.sourcePartitionStoreItem;
    }

    public void setSourcePartitionStoreItem(SourcePartitionStoreItem sourcePartitionStoreItem) {
        this.sourcePartitionStoreItem = sourcePartitionStoreItem;
    }

    public T convertStringToPartitionProgressState(Class<T> progressStateClass, String serializedPartitionProgressState) {
        if (Objects.isNull(serializedPartitionProgressState)) {
            return null;
        }
        try {
            if (progressStateClass != null) {
                return (T)objectMapper.readValue(serializedPartitionProgressState, progressStateClass);
            }
            return (T)objectMapper.readValue(serializedPartitionProgressState, new TypeReference<T>(){});
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to convert string to partition progress state class {}: ", (Object)(progressStateClass != null ? progressStateClass.getName() : null), (Object)e);
            return null;
        }
    }

    public String convertPartitionProgressStatetoString(Optional<T> partitionProgressState) {
        if (partitionProgressState.isEmpty()) {
            return null;
        }
        try {
            return objectMapper.writeValueAsString(partitionProgressState.get());
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to convert partition progress state class to string: ", (Throwable)e);
            return null;
        }
    }
}

