/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.typeconverter;

import org.opensearch.dataprepper.typeconverter.ConverterArguments;
import org.opensearch.dataprepper.typeconverter.TypeConverter;

public class BooleanConverter
implements TypeConverter<Boolean> {
    @Override
    public Boolean convert(Object source, ConverterArguments arguments) throws IllegalArgumentException {
        return this.convert(source);
    }

    @Override
    public Boolean convert(Object source) throws IllegalArgumentException {
        if (source instanceof String) {
            return Boolean.parseBoolean((String)source);
        }
        if (source instanceof Number) {
            Number number = (Number)source;
            return number instanceof Integer && number.intValue() != 0 || number instanceof Long && number.longValue() != 0L || number instanceof Short && number.shortValue() != 0 || number instanceof Byte && number.byteValue() != 0 || number.floatValue() != 0.0f || number.doubleValue() != 0.0;
        }
        if (source instanceof Boolean) {
            return (Boolean)source;
        }
        throw new IllegalArgumentException("Unsupported type conversion. Source class: " + source.getClass());
    }
}

