/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.types;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.model.types.ByteCountInvalidInputException;
import org.opensearch.dataprepper.model.types.ByteCountParseException;

public class ByteCount {
    private static final Pattern BYTE_PATTERN = Pattern.compile("^(?<value>\\d+\\.?\\d*)(?<unit>[a-z]+)?\\z");
    private static final ByteCount ZERO_BYTES = new ByteCount(0L);
    private final long bytes;

    private ByteCount(long bytes) {
        this.bytes = bytes;
    }

    public long getBytes() {
        return this.bytes;
    }

    public static ByteCount parse(String string) {
        Matcher matcher = BYTE_PATTERN.matcher(string);
        if (!matcher.find()) {
            throw new ByteCountParseException("Unable to parse bytes provided by '" + string + "'");
        }
        String valueString = matcher.group("value");
        String unitString = matcher.group("unit");
        if (unitString == null) {
            throw new ByteCountInvalidInputException("Byte counts must have a unit.");
        }
        Unit unit = Unit.fromString(unitString).orElseThrow(() -> new ByteCountInvalidInputException("Invalid byte unit: '" + unitString + "'"));
        BigDecimal valueBigDecimal = new BigDecimal(valueString);
        BigDecimal byteCount = ByteCount.scaleToBytes(valueBigDecimal, unit);
        if (unit == Unit.BYTE && ByteCount.isFractional(byteCount)) {
            throw new ByteCountInvalidInputException("The byte value '" + string + "' is explicitly declared as a fractional byte which is not allowed.");
        }
        return new ByteCount(byteCount.longValue());
    }

    public static ByteCount ofBytes(long bytes) {
        if (bytes < 0L) {
            throw new IllegalArgumentException("The argument provided for bytes is negative.");
        }
        return new ByteCount(bytes);
    }

    public static ByteCount zeroBytes() {
        return ZERO_BYTES;
    }

    private static BigDecimal scaleToBytes(BigDecimal value, Unit unit) {
        return value.multiply(BigDecimal.valueOf(unit.multiplier));
    }

    private static boolean isFractional(BigDecimal value) {
        return value.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) != 0;
    }

    public int hashCode() {
        return Objects.hashCode(this.bytes);
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof ByteCount)) {
            return false;
        }
        return ((ByteCount)otherObject).bytes == this.bytes;
    }

    public String toString() {
        return this.bytes + Unit.BYTE.unitString;
    }

    private static enum Unit {
        BYTE("b", 1L),
        KILOBYTE("kb", 1024L),
        MEGABYTE("mb", Unit.KILOBYTE.multiplier * 1024L),
        GIGABYTE("gb", Unit.MEGABYTE.multiplier * 1024L);

        private final String unitString;
        private final long multiplier;
        private static final Map<String, Unit> UNIT_MAP;

        private Unit(String unitString, long multiplier) {
            this.unitString = unitString;
            this.multiplier = multiplier;
        }

        static Optional<Unit> fromString(String unitString) {
            return Optional.ofNullable(UNIT_MAP.get(unitString));
        }

        static {
            UNIT_MAP = Arrays.stream(Unit.values()).collect(Collectors.toMap(unit -> unit.unitString, Function.identity()));
        }
    }
}

