/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.event;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.opensearch.dataprepper.model.event.EventKey;

public interface EventKeyFactory {
    public EventKey createEventKey(String var1, EventAction ... var2);

    default public EventKey createEventKey(String key) {
        return this.createEventKey(key, EventAction.ALL);
    }

    public static enum EventAction {
        GET(new EventAction[0]),
        DELETE(new EventAction[0]),
        PUT(new EventAction[0]),
        ALL(GET, DELETE, PUT);

        private final List<EventAction> includedActions;

        private EventAction(EventAction ... eventActions) {
            this.includedActions = Arrays.asList(eventActions);
        }

        boolean isMutableAction() {
            return this != GET;
        }

        Set<EventAction> getSupportedActions() {
            EnumSet<EventAction> supportedActions = EnumSet.noneOf(EventAction.class);
            supportedActions.add(this);
            supportedActions.addAll(this.includedActions);
            return Collections.unmodifiableSet(supportedActions);
        }
    }
}

