/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.buffer;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.opensearch.dataprepper.model.CheckpointState;
import org.opensearch.dataprepper.model.record.Record;

public interface Buffer<T extends Record<?>> {
    public void write(T var1, int var2) throws TimeoutException;

    public void writeAll(Collection<T> var1, int var2) throws Exception;

    default public void writeBytes(byte[] bytes, String key, int timeoutInMillis) throws Exception {
        throw new UnsupportedOperationException("This buffer type does not support bytes.");
    }

    public Map.Entry<Collection<T>, CheckpointState> read(int var1);

    public void checkpoint(CheckpointState var1);

    public boolean isEmpty();

    default public boolean isByteBuffer() {
        return false;
    }

    default public Optional<Integer> getMaxRequestSize() {
        return Optional.empty();
    }

    default public Optional<Integer> getOptimalRequestSize() {
        return Optional.empty();
    }

    default public boolean areAcknowledgementsEnabled() {
        return false;
    }

    default public Duration getDrainTimeout() {
        return Duration.ZERO;
    }

    default public boolean isWrittenOffHeapOnly() {
        return false;
    }

    default public void shutdown() {
    }
}

