/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.StringJoiner;
import java.util.function.ToDoubleFunction;
import org.opensearch.dataprepper.model.configuration.PluginSetting;

public class PluginMetrics {
    private final String metricsPrefix;

    public static PluginMetrics fromPluginSetting(PluginSetting pluginSetting) {
        if (pluginSetting.getPipelineName() == null) {
            throw new IllegalArgumentException("PluginSetting.pipelineName must not be null");
        }
        return PluginMetrics.fromNames(pluginSetting.getName(), pluginSetting.getPipelineName());
    }

    public static PluginMetrics fromNames(String componentId, String componentScope) {
        return new PluginMetrics(new StringJoiner(".").add(componentScope).add(componentId).toString());
    }

    public static PluginMetrics fromPrefix(String metricsPrefix) {
        return new PluginMetrics(metricsPrefix);
    }

    private PluginMetrics(String metricsPrefix) {
        this.metricsPrefix = metricsPrefix;
    }

    public Counter counter(String name) {
        return Metrics.counter((String)this.getMeterName(name), (String[])new String[0]);
    }

    public Counter counterWithTags(String name, String ... tags) {
        return Metrics.counter((String)this.getMeterName(name), (String[])tags);
    }

    public Counter counter(String name, String metricsPrefix) {
        return Metrics.counter((String)new StringJoiner(".").add(metricsPrefix).add(name).toString(), (String[])new String[0]);
    }

    public Timer timer(String name) {
        return Metrics.timer((String)this.getMeterName(name), (String[])new String[0]);
    }

    public Timer timerWithTags(String name, String ... tags) {
        return Metrics.timer((String)this.getMeterName(name), (String[])tags);
    }

    public DistributionSummary summary(String name) {
        return Metrics.summary((String)this.getMeterName(name), (String[])new String[0]);
    }

    public <T extends Number> T gauge(String name, T number) {
        return (T)Metrics.gauge((String)this.getMeterName(name), number);
    }

    public <T> T gauge(String name, T obj, ToDoubleFunction<T> valueFunction) {
        return (T)Metrics.gauge((String)this.getMeterName(name), obj, valueFunction);
    }

    public <T> T gaugeWithTags(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> valueFunction) {
        return (T)Metrics.gauge((String)this.getMeterName(name), tags, obj, valueFunction);
    }

    private String getMeterName(String name) {
        return new StringJoiner(".").add(this.metricsPrefix).add(name).toString();
    }
}

