/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import org.opensearch.dataprepper.model.event.EventMetadata;

public class DefaultEventMetadata
implements EventMetadata {
    private final String eventType;
    private final Instant timeReceived;
    private final ImmutableMap<String, Object> attributes;

    private DefaultEventMetadata(Builder builder) {
        Preconditions.checkNotNull((Object)builder.eventType, (Object)"eventType cannot be null");
        Preconditions.checkArgument((!builder.eventType.isEmpty() ? 1 : 0) != 0, (Object)"eventType cannot be empty");
        this.eventType = builder.eventType;
        this.timeReceived = builder.timeReceived == null ? Instant.now() : builder.timeReceived;
        this.attributes = builder.attributes == null ? ImmutableMap.of() : ImmutableMap.copyOf(builder.attributes);
    }

    private DefaultEventMetadata(EventMetadata eventMetadata) {
        this.eventType = eventMetadata.getEventType();
        this.timeReceived = eventMetadata.getTimeReceived();
        this.attributes = ImmutableMap.copyOf(eventMetadata.getAttributes());
    }

    @Override
    public String getEventType() {
        return this.eventType;
    }

    @Override
    public Instant getTimeReceived() {
        return this.timeReceived;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultEventMetadata that = (DefaultEventMetadata)o;
        return Objects.equals(this.eventType, that.eventType) && Objects.equals(this.timeReceived, that.timeReceived) && Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.eventType, this.timeReceived, this.attributes);
    }

    public String toString() {
        return "DefaultEventMetadata{eventType='" + this.eventType + "', timeReceived=" + this.timeReceived + ", attributes=" + this.attributes + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    static EventMetadata fromEventMetadata(EventMetadata eventMetadata) {
        return new DefaultEventMetadata(eventMetadata);
    }

    public static class Builder {
        private String eventType;
        private Instant timeReceived;
        private Map<String, Object> attributes;

        public Builder withEventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder withTimeReceived(Instant timeReceived) {
            this.timeReceived = timeReceived;
            return this;
        }

        public Builder withAttributes(Map<String, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        public DefaultEventMetadata build() {
            return new DefaultEventMetadata(this);
        }
    }
}

