/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.sink;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.util.Collection;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.sink.Sink;

public abstract class AbstractSink<T extends Record<?>>
implements Sink<T> {
    protected final PluginMetrics pluginMetrics;
    private final Counter recordsInCounter;
    private final Timer timeElapsedTimer;

    public AbstractSink(PluginSetting pluginSetting) {
        this.pluginMetrics = PluginMetrics.fromPluginSetting(pluginSetting);
        this.recordsInCounter = this.pluginMetrics.counter("recordsIn");
        this.timeElapsedTimer = this.pluginMetrics.timer("timeElapsed");
    }

    @Override
    public void output(Collection<T> records) {
        this.recordsInCounter.increment((double)records.size() * 1.0);
        this.timeElapsedTimer.record(() -> this.doOutput(records));
    }

    public abstract void doOutput(Collection<T> var1);
}

