/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.model.configuration.PluginModel;

@JsonSerialize(using=PluginModel.PluginModelSerializer.class)
@JsonDeserialize(using=SinkModelDeserializer.class)
public class SinkModel
extends PluginModel {
    SinkModel(String pluginName, List<String> routes, Map<String, Object> pluginSettings) {
        this(pluginName, new SinkInternalJsonModel(routes, pluginSettings));
    }

    private SinkModel(String pluginName, SinkInternalJsonModel sinkInnerModel) {
        super(pluginName, sinkInnerModel);
    }

    public Collection<String> getRoutes() {
        return ((SinkInternalJsonModel)this.getInternalJsonModel()).routes;
    }

    public static SinkModelBuilder builder(PluginModel pluginModel) {
        return new SinkModelBuilder(pluginModel);
    }

    static class SinkModelDeserializer
    extends PluginModel.AbstractPluginModelDeserializer<SinkModel, SinkInternalJsonModel> {
        SinkModelDeserializer() {
            super(SinkModel.class, SinkInternalJsonModel.class, (x$0, x$1) -> new SinkModel((String)x$0, (SinkInternalJsonModel)x$1), () -> new SinkInternalJsonModel(null));
        }
    }

    private static class SinkInternalJsonModel
    extends PluginModel.InternalJsonModel {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="routes")
        private final List<String> routes;

        @JsonCreator
        private SinkInternalJsonModel(@JsonProperty(value="routes") List<String> routes) {
            this.routes = routes != null ? routes : new ArrayList();
        }

        private SinkInternalJsonModel(List<String> routes, Map<String, Object> pluginSettings) {
            super(pluginSettings);
            this.routes = routes != null ? routes : new ArrayList();
        }
    }

    public static class SinkModelBuilder {
        private final PluginModel pluginModel;
        private final List<String> routes;

        private SinkModelBuilder(PluginModel pluginModel) {
            this.pluginModel = pluginModel;
            this.routes = Collections.emptyList();
        }

        public SinkModel build() {
            return new SinkModel(this.pluginModel.getPluginName(), this.routes, this.pluginModel.getPluginSettings());
        }
    }
}

