/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.metric;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.opensearch.dataprepper.model.event.EventType;
import org.opensearch.dataprepper.model.metric.DefaultQuantile;
import org.opensearch.dataprepper.model.metric.JacksonMetric;
import org.opensearch.dataprepper.model.metric.Metric;
import org.opensearch.dataprepper.model.metric.ParameterValidator;
import org.opensearch.dataprepper.model.metric.Quantile;
import org.opensearch.dataprepper.model.metric.Summary;

public class JacksonSummary
extends JacksonMetric
implements Summary {
    private static final String QUANTILES_KEY = "quantiles";
    private static final String QUANTILE_VALUES_COUNT_KEY = "quantileValuesCount";
    private static final String SUM_KEY = "sum";
    private static final String COUNT_KEY = "count";
    private static final List<String> REQUIRED_KEYS = Collections.singletonList("attributes");
    private static final List<String> REQUIRED_NON_EMPTY_KEYS = Arrays.asList("name", "kind", "time");
    private static final List<String> REQUIRED_NON_NULL_KEYS = Collections.emptyList();

    protected JacksonSummary(Builder builder) {
        super(builder);
        Preconditions.checkArgument((boolean)this.getMetadata().getEventType().equals(EventType.METRIC.toString()), (Object)"eventType must be of type Metric");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public List<? extends Quantile> getQuantiles() {
        return this.getList(QUANTILES_KEY, DefaultQuantile.class);
    }

    @Override
    public Long getCount() {
        return this.get(COUNT_KEY, Long.class);
    }

    @Override
    public Integer getQuantileValuesCount() {
        return this.get(QUANTILE_VALUES_COUNT_KEY, Integer.class);
    }

    @Override
    public Double getSum() {
        return this.get(SUM_KEY, Double.class);
    }

    public static class Builder
    extends JacksonMetric.Builder<Builder> {
        @Override
        public Builder getThis() {
            return this;
        }

        public Builder withQuantiles(List<Quantile> quantiles) {
            this.data.put(JacksonSummary.QUANTILES_KEY, quantiles);
            return this;
        }

        public Builder withQuantilesValueCount(int quantileValuesCount) {
            this.data.put(JacksonSummary.QUANTILE_VALUES_COUNT_KEY, quantileValuesCount);
            return this;
        }

        public Builder withSum(double sum) {
            this.data.put(JacksonSummary.SUM_KEY, sum);
            return this;
        }

        public Builder withCount(Long count) {
            this.data.put(JacksonSummary.COUNT_KEY, count);
            return this;
        }

        @Override
        public JacksonSummary build() {
            this.withData(this.data);
            this.withEventKind(Metric.KIND.SUMMARY.toString());
            this.withEventType(EventType.METRIC.toString());
            new ParameterValidator().validate(REQUIRED_KEYS, REQUIRED_NON_EMPTY_KEYS, REQUIRED_NON_NULL_KEYS, this.data);
            this.checkAndSetDefaultValues();
            return new JacksonSummary(this);
        }

        private void checkAndSetDefaultValues() {
            this.data.computeIfAbsent("attributes", k -> new HashMap());
        }
    }
}

