/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

@JsonSerialize(using=ConditionalRouteSerializer.class)
@JsonDeserialize(using=ConditionalRouteDeserializer.class)
public class ConditionalRoute {
    private final String name;
    private final String condition;

    @JsonCreator
    public ConditionalRoute(String name, String condition) {
        this.name = name;
        this.condition = condition;
    }

    public String getName() {
        return this.name;
    }

    public String getCondition() {
        return this.condition;
    }

    static class ConditionalRouteDeserializer
    extends StdDeserializer<ConditionalRoute> {
        protected ConditionalRouteDeserializer() {
            super(ConditionalRoute.class);
        }

        public ConditionalRoute deserialize(JsonParser parser, DeserializationContext context) throws IOException, JacksonException {
            JsonNode node = context.readTree(parser);
            Iterator fields = node.fields();
            Map.Entry onlyField = (Map.Entry)fields.next();
            String routeName = (String)onlyField.getKey();
            JsonNode value = (JsonNode)onlyField.getValue();
            if (!value.isTextual()) {
                throw new InvalidFormatException(parser, "Route has a condition which is not a string.", (Object)value, String.class);
            }
            String condition = value.asText();
            if (fields.hasNext()) {
                throw new InvalidFormatException(parser, "Route has too many fields.", null, String.class);
            }
            return new ConditionalRoute(routeName, condition);
        }
    }

    static class ConditionalRouteSerializer
    extends StdSerializer<ConditionalRoute> {
        protected ConditionalRouteSerializer() {
            super(ConditionalRoute.class);
        }

        public void serialize(ConditionalRoute value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeObjectField(value.name, (Object)value.condition);
            gen.writeEndObject();
        }
    }
}

