/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dataprepper.model.metric;

import com.amazon.dataprepper.model.event.EventType;
import com.amazon.dataprepper.model.metric.Bucket;
import com.amazon.dataprepper.model.metric.DefaultBucket;
import com.amazon.dataprepper.model.metric.Histogram;
import com.amazon.dataprepper.model.metric.JacksonMetric;
import com.amazon.dataprepper.model.metric.Metric;
import com.amazon.dataprepper.model.metric.ParameterValidator;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class JacksonHistogram
extends JacksonMetric
implements Histogram {
    private static final String SUM_KEY = "sum";
    private static final String COUNT_KEY = "count";
    private static final String AGGREGATION_TEMPORALITY_KEY = "aggregationTemporality";
    private static final String BUCKET_COUNTS_KEY = "bucketCounts";
    private static final String EXPLICIT_BOUNDS_COUNT_KEY = "explicitBoundsCount";
    private static final String BUCKETS_KEY = "buckets";
    private static final List<String> REQUIRED_KEYS = new ArrayList<String>();
    private static final List<String> REQUIRED_NON_EMPTY_KEYS = Arrays.asList("name", "kind", "time");
    private static final List<String> REQUIRED_NON_NULL_KEYS = Collections.singletonList("sum");

    protected JacksonHistogram(Builder builder) {
        super(builder);
        Preconditions.checkArgument((boolean)this.getMetadata().getEventType().equals(EventType.METRIC.toString()), (Object)"eventType must be of type Metric");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Double getSum() {
        return this.get(SUM_KEY, Double.class);
    }

    @Override
    public Long getCount() {
        return this.get(COUNT_KEY, Long.class);
    }

    @Override
    public String getAggregationTemporality() {
        return this.get(AGGREGATION_TEMPORALITY_KEY, String.class);
    }

    @Override
    public Integer getBucketCount() {
        return this.get(BUCKET_COUNTS_KEY, Integer.class);
    }

    @Override
    public Integer getExplicitBoundsCount() {
        return this.get(EXPLICIT_BOUNDS_COUNT_KEY, Integer.class);
    }

    @Override
    public List<? extends Bucket> getBuckets() {
        return this.getList(BUCKETS_KEY, DefaultBucket.class);
    }

    public static class Builder
    extends JacksonMetric.Builder<Builder> {
        @Override
        public Builder getThis() {
            return this;
        }

        public Builder withSum(double sum) {
            this.data.put(JacksonHistogram.SUM_KEY, sum);
            return this;
        }

        public Builder withCount(long count) {
            this.data.put(JacksonHistogram.COUNT_KEY, count);
            return this;
        }

        public Builder withBucketCount(int bucketCount) {
            this.data.put(JacksonHistogram.BUCKET_COUNTS_KEY, bucketCount);
            return this;
        }

        public Builder withExplicitBoundsCount(int explicitBoundsCount) {
            this.data.put(JacksonHistogram.EXPLICIT_BOUNDS_COUNT_KEY, explicitBoundsCount);
            return this;
        }

        public Builder withAggregationTemporality(String aggregationTemporality) {
            this.data.put(JacksonHistogram.AGGREGATION_TEMPORALITY_KEY, aggregationTemporality);
            return this;
        }

        public Builder withBuckets(List<Bucket> buckets) {
            this.data.put(JacksonHistogram.BUCKETS_KEY, buckets);
            return this;
        }

        @Override
        public JacksonHistogram build() {
            this.withData(this.data);
            this.withEventKind(Metric.KIND.HISTOGRAM.toString());
            this.withEventType(EventType.METRIC.toString());
            this.checkAndSetDefaultValues();
            new ParameterValidator().validate(REQUIRED_KEYS, REQUIRED_NON_EMPTY_KEYS, REQUIRED_NON_NULL_KEYS, this.data);
            return new JacksonHistogram(this);
        }

        private void checkAndSetDefaultValues() {
            this.data.computeIfAbsent("attributes", k -> new HashMap());
        }
    }
}

