/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dataprepper.model.event;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum EventType {
    LOG("LOG"),
    TRACE("TRACE");

    private static final Map<String, EventType> NAMES_MAP;
    private final String name;

    private EventType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static EventType getByName(String name) {
        return NAMES_MAP.get(name.toUpperCase());
    }

    static {
        NAMES_MAP = Arrays.stream(EventType.values()).collect(Collectors.toMap(EventType::toString, Function.identity()));
    }
}

