/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.osc;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.client.opensearch._types.AcknowledgedResponseBase;
import org.opensearch.client.opensearch.cluster.ExistsComponentTemplateRequest;
import org.opensearch.client.opensearch.cluster.PutComponentTemplateRequest;
import org.opensearch.client.opensearch.indices.CreateIndexRequest;
import org.opensearch.client.opensearch.indices.CreateIndexResponse;
import org.opensearch.client.opensearch.indices.DeleteIndexRequest;
import org.opensearch.client.opensearch.indices.DeleteIndexTemplateRequest;
import org.opensearch.client.opensearch.indices.DeleteTemplateRequest;
import org.opensearch.client.opensearch.indices.ExistsRequest;
import org.opensearch.client.opensearch.indices.GetAliasRequest;
import org.opensearch.client.opensearch.indices.GetIndexRequest;
import org.opensearch.client.opensearch.indices.GetIndexTemplateRequest;
import org.opensearch.client.opensearch.indices.GetIndicesSettingsRequest;
import org.opensearch.client.opensearch.indices.GetIndicesSettingsResponse;
import org.opensearch.client.opensearch.indices.GetMappingRequest;
import org.opensearch.client.opensearch.indices.GetMappingResponse;
import org.opensearch.client.opensearch.indices.GetTemplateResponse;
import org.opensearch.client.opensearch.indices.PutIndexTemplateRequest;
import org.opensearch.client.opensearch.indices.PutMappingRequest;
import org.opensearch.client.opensearch.indices.RefreshRequest;
import org.opensearch.client.opensearch.indices.UpdateAliasesRequest;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.endpoints.BooleanResponse;
import org.opensearch.data.client.osc.ReactiveChildTemplate;
import org.opensearch.data.client.osc.ReactiveClusterTemplate;
import org.opensearch.data.client.osc.ReactiveOpenSearchIndicesClient;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.elasticsearch.NoSuchIndexException;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.core.IndexInformation;
import org.springframework.data.elasticsearch.core.ReactiveIndexOperations;
import org.springframework.data.elasticsearch.core.ReactiveResourceUtil;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasActions;
import org.springframework.data.elasticsearch.core.index.AliasData;
import org.springframework.data.elasticsearch.core.index.DeleteComponentTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsIndexTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsTemplateRequest;
import org.springframework.data.elasticsearch.core.index.GetComponentTemplateRequest;
import org.springframework.data.elasticsearch.core.index.GetTemplateRequest;
import org.springframework.data.elasticsearch.core.index.PutTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ReactiveMappingBuilder;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.data.elasticsearch.core.index.TemplateData;
import org.springframework.data.elasticsearch.core.index.TemplateResponse;
import org.springframework.data.elasticsearch.core.mapping.Alias;
import org.springframework.data.elasticsearch.core.mapping.CreateIndexSettings;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveIndicesTemplate
extends ReactiveChildTemplate<OpenSearchTransport, ReactiveOpenSearchIndicesClient>
implements ReactiveIndexOperations {
    private final ReactiveClusterTemplate clusterTemplate;
    @Nullable
    private final Class<?> boundClass;
    private final IndexCoordinates boundIndexCoordinates;

    public ReactiveIndicesTemplate(ReactiveOpenSearchIndicesClient client, ReactiveClusterTemplate clusterTemplate, ElasticsearchConverter elasticsearchConverter, IndexCoordinates index) {
        super(client, elasticsearchConverter);
        Assert.notNull((Object)index, (String)"index must not be null");
        Assert.notNull((Object)clusterTemplate, (String)"clusterTemplate must not be null");
        this.clusterTemplate = clusterTemplate;
        this.boundClass = null;
        this.boundIndexCoordinates = index;
    }

    public ReactiveIndicesTemplate(ReactiveOpenSearchIndicesClient client, ReactiveClusterTemplate clusterTemplate, ElasticsearchConverter elasticsearchConverter, Class<?> clazz) {
        super(client, elasticsearchConverter);
        Assert.notNull(clazz, (String)"clazz must not be null");
        Assert.notNull((Object)clusterTemplate, (String)"clusterTemplate must not be null");
        this.clusterTemplate = clusterTemplate;
        this.boundClass = clazz;
        this.boundIndexCoordinates = this.getIndexCoordinatesFor(clazz);
    }

    public Mono<Boolean> create() {
        IndexCoordinates indexCoordinates = this.getIndexCoordinates();
        if (this.boundClass != null) {
            return this.createSettings(this.boundClass).flatMap(settings -> this.doCreate(indexCoordinates, (Map<String, Object>)settings, null));
        }
        return this.doCreate(indexCoordinates, (Map<String, Object>)new Settings(), null);
    }

    public Mono<Boolean> create(Map<String, Object> settings) {
        Assert.notNull(settings, (String)"settings must not be null");
        return this.doCreate(this.getIndexCoordinates(), settings, null);
    }

    public Mono<Boolean> create(Map<String, Object> settings, Document mapping) {
        Assert.notNull(settings, (String)"settings must not be null");
        Assert.notNull((Object)mapping, (String)"mapping must not be null");
        return this.doCreate(this.getIndexCoordinates(), settings, mapping);
    }

    public Mono<Boolean> createWithMapping() {
        return this.createSettings().flatMap(settings -> this.createMapping().flatMap(mapping -> this.doCreate(this.getIndexCoordinates(), (Map<String, Object>)settings, (Document)mapping)));
    }

    private Mono<Boolean> doCreate(IndexCoordinates indexCoordinates, Map<String, Object> settings, @Nullable Document mapping) {
        Set<Object> aliases = this.boundClass != null ? this.getAliasesFor(this.boundClass) : new HashSet();
        CreateIndexSettings indexSettings = CreateIndexSettings.builder((IndexCoordinates)indexCoordinates).withAliases(aliases).withSettings(settings).withMapping(mapping).build();
        CreateIndexRequest createIndexRequest = this.requestConverter.indicesCreateRequest(indexSettings);
        Mono createIndexResponse = Mono.from(this.execute(client -> client.create(createIndexRequest)));
        return createIndexResponse.map(CreateIndexResponse::acknowledged);
    }

    public Mono<Boolean> delete() {
        return this.exists().flatMap(exists -> {
            if (exists.booleanValue()) {
                DeleteIndexRequest deleteIndexRequest = this.requestConverter.indicesDeleteRequest(this.getIndexCoordinates());
                return Mono.from(this.execute(client -> client.delete(deleteIndexRequest))).map(AcknowledgedResponseBase::acknowledged).onErrorResume(NoSuchIndexException.class, e -> Mono.just((Object)false));
            }
            return Mono.just((Object)false);
        });
    }

    public Mono<Boolean> exists() {
        ExistsRequest existsRequest = this.requestConverter.indicesExistsRequest(this.getIndexCoordinates());
        Mono existsResponse = Mono.from(this.execute(client -> client.exists(existsRequest)));
        return existsResponse.map(BooleanResponse::value);
    }

    public Mono<Void> refresh() {
        RefreshRequest refreshRequest = this.requestConverter.indicesRefreshRequest(this.getIndexCoordinates());
        return Mono.from(this.execute(client -> client.refresh(refreshRequest))).then();
    }

    public Mono<Document> createMapping() {
        return this.createMapping(this.checkForBoundClass());
    }

    public Mono<Document> createMapping(Class<?> clazz) {
        String mappingPath;
        Assert.notNull(clazz, (String)"clazz must not be null");
        Mapping mappingAnnotation = (Mapping)AnnotatedElementUtils.findMergedAnnotation(clazz, Mapping.class);
        if (mappingAnnotation != null && StringUtils.hasText((String)(mappingPath = mappingAnnotation.mappingPath()))) {
            return ReactiveResourceUtil.loadDocument((String)mappingAnnotation.mappingPath(), (String)"@Mapping");
        }
        return new ReactiveMappingBuilder(this.elasticsearchConverter).buildReactivePropertyMapping(clazz).map(Document::parse);
    }

    public Mono<Boolean> putMapping(Mono<Document> mapping) {
        Assert.notNull(mapping, (String)"mapping must not be null");
        Mono putMappingResponse = mapping.map(document -> this.requestConverter.indicesPutMappingRequest(this.getIndexCoordinates(), (Document)document)).flatMap(putMappingRequest -> Mono.from(((ReactiveOpenSearchIndicesClient)this.client).putMapping((PutMappingRequest)putMappingRequest)));
        return putMappingResponse.map(AcknowledgedResponseBase::acknowledged);
    }

    public Mono<Document> getMapping() {
        IndexCoordinates indexCoordinates = this.getIndexCoordinates();
        GetMappingRequest getMappingRequest = this.requestConverter.indicesGetMappingRequest(indexCoordinates);
        Mono getMappingResponse = Mono.from(this.execute(client -> client.getMapping(getMappingRequest)));
        return getMappingResponse.map(response -> this.responseConverter.indicesGetMapping((GetMappingResponse)response, indexCoordinates));
    }

    public Mono<Settings> createSettings() {
        return this.createSettings(this.checkForBoundClass());
    }

    public Mono<Settings> createSettings(Class<?> clazz) {
        Assert.notNull(clazz, (String)"clazz must not be null");
        ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(clazz);
        String settingPath = persistentEntity.settingPath();
        return StringUtils.hasText((String)settingPath) ? ReactiveResourceUtil.loadDocument((String)settingPath, (String)"@Setting").map(Settings::new) : Mono.just((Object)persistentEntity.getDefaultSettings());
    }

    public Mono<Settings> getSettings(boolean includeDefaults) {
        GetIndicesSettingsRequest getSettingsRequest = this.requestConverter.indicesGetSettingsRequest(this.getIndexCoordinates(), includeDefaults);
        Mono getSettingsResponse = Mono.from(this.execute(client -> client.getSettings(getSettingsRequest)));
        return getSettingsResponse.map(response -> this.responseConverter.indicesGetSettings((GetIndicesSettingsResponse)response, this.getIndexCoordinates().getIndexName()));
    }

    public Mono<Boolean> alias(AliasActions aliasActions) {
        Assert.notNull((Object)aliasActions, (String)"aliasActions must not be null");
        UpdateAliasesRequest updateAliasesRequest = this.requestConverter.indicesUpdateAliasesRequest(aliasActions);
        Mono updateAliasesResponse = Mono.from(this.execute(client -> client.updateAliases(updateAliasesRequest)));
        return updateAliasesResponse.map(AcknowledgedResponseBase::acknowledged);
    }

    public Mono<Map<String, Set<AliasData>>> getAliases(String ... aliasNames) {
        return this.getAliases(aliasNames, (String[])null);
    }

    public Mono<Map<String, Set<AliasData>>> getAliasesForIndex(String ... indexNames) {
        return this.getAliases((String[])null, indexNames);
    }

    private Mono<Map<String, Set<AliasData>>> getAliases(@Nullable String[] aliasNames, @Nullable String[] indexNames) {
        GetAliasRequest getAliasRequest = this.requestConverter.indicesGetAliasRequest(aliasNames, indexNames);
        Mono getAliasResponse = Mono.from(this.execute(client -> client.getAlias(getAliasRequest)));
        return getAliasResponse.map(this.responseConverter::indicesGetAliasData);
    }

    public Mono<Boolean> putTemplate(PutTemplateRequest putTemplateRequest) {
        Assert.notNull((Object)putTemplateRequest, (String)"putTemplateRequest must not be null");
        org.opensearch.client.opensearch.indices.PutTemplateRequest putTemplateRequestES = this.requestConverter.indicesPutTemplateRequest(putTemplateRequest);
        Mono putTemplateResponse = Mono.from(this.execute(client -> client.putTemplate(putTemplateRequestES)));
        return putTemplateResponse.map(AcknowledgedResponseBase::acknowledged);
    }

    public Mono<Boolean> putComponentTemplate(org.springframework.data.elasticsearch.core.index.PutComponentTemplateRequest putComponentTemplateRequest) {
        Assert.notNull((Object)putComponentTemplateRequest, (String)"putComponentTemplateRequest must not be null");
        PutComponentTemplateRequest putComponentTemplateRequestES = this.requestConverter.clusterPutComponentTemplateRequest(putComponentTemplateRequest);
        return Mono.from(this.clusterTemplate.execute(client -> client.putComponentTemplate(putComponentTemplateRequestES))).map(AcknowledgedResponseBase::acknowledged);
    }

    public Flux<TemplateResponse> getComponentTemplate(GetComponentTemplateRequest getComponentTemplateRequest) {
        Assert.notNull((Object)getComponentTemplateRequest, (String)"getComponentTemplateRequest must not be null");
        org.opensearch.client.opensearch.cluster.GetComponentTemplateRequest getComponentTemplateRequestES = this.requestConverter.clusterGetComponentTemplateRequest(getComponentTemplateRequest);
        return Flux.from(this.clusterTemplate.execute(client -> client.getComponentTemplate(getComponentTemplateRequestES))).flatMapIterable(this.responseConverter::clusterGetComponentTemplates);
    }

    public Mono<Boolean> existsComponentTemplate(org.springframework.data.elasticsearch.core.index.ExistsComponentTemplateRequest existsComponentTemplateRequest) {
        Assert.notNull((Object)existsComponentTemplateRequest, (String)"existsComponentTemplateRequest must not be null");
        ExistsComponentTemplateRequest existsComponentTemplateRequestES = this.requestConverter.clusterExistsComponentTemplateRequest(existsComponentTemplateRequest);
        return Mono.from(this.clusterTemplate.execute(client -> client.existsComponentTemplate(existsComponentTemplateRequestES))).map(BooleanResponse::value);
    }

    public Mono<Boolean> deleteComponentTemplate(DeleteComponentTemplateRequest deleteComponentTemplateRequest) {
        Assert.notNull((Object)deleteComponentTemplateRequest, (String)"deleteComponentTemplateRequest must not be null");
        org.opensearch.client.opensearch.cluster.DeleteComponentTemplateRequest deleteComponentTemplateRequestES = this.requestConverter.clusterDeleteComponentTemplateRequest(deleteComponentTemplateRequest);
        return Mono.from(this.clusterTemplate.execute(client -> client.deleteComponentTemplate(deleteComponentTemplateRequestES))).map(AcknowledgedResponseBase::acknowledged);
    }

    public Mono<Boolean> putIndexTemplate(org.springframework.data.elasticsearch.core.index.PutIndexTemplateRequest putIndexTemplateRequest) {
        Assert.notNull((Object)putIndexTemplateRequest, (String)"putIndexTemplateRequest must not be null");
        PutIndexTemplateRequest putIndexTemplateRequestES = this.requestConverter.indicesPutIndexTemplateRequest(putIndexTemplateRequest);
        return Mono.from(this.execute(client -> client.putIndexTemplate(putIndexTemplateRequestES))).map(AcknowledgedResponseBase::acknowledged);
    }

    public Mono<Boolean> existsIndexTemplate(ExistsIndexTemplateRequest existsIndexTemplateRequest) {
        Assert.notNull((Object)existsIndexTemplateRequest, (String)"existsIndexTemplateRequest must not be null");
        org.opensearch.client.opensearch.indices.ExistsIndexTemplateRequest existsIndexTemplateRequestES = this.requestConverter.indicesExistsIndexTemplateRequest(existsIndexTemplateRequest);
        return Mono.from(this.execute(client -> client.existsIndexTemplate(existsIndexTemplateRequestES))).map(BooleanResponse::value);
    }

    public Flux<TemplateResponse> getIndexTemplate(org.springframework.data.elasticsearch.core.index.GetIndexTemplateRequest getIndexTemplateRequest) {
        Assert.notNull((Object)getIndexTemplateRequest, (String)"getIndexTemplateRequest must not be null");
        GetIndexTemplateRequest getIndexTemplateRequestES = this.requestConverter.indicesGetIndexTemplateRequest(getIndexTemplateRequest);
        return Mono.from(this.execute(client -> client.getIndexTemplate(getIndexTemplateRequestES))).flatMapIterable(this.responseConverter::getIndexTemplates);
    }

    public Mono<Boolean> deleteIndexTemplate(org.springframework.data.elasticsearch.core.index.DeleteIndexTemplateRequest deleteIndexTemplateRequest) {
        Assert.notNull((Object)deleteIndexTemplateRequest, (String)"deleteIndexTemplateRequest must not be null");
        DeleteIndexTemplateRequest deleteIndexTemplateRequestES = this.requestConverter.indicesDeleteIndexTemplateRequest(deleteIndexTemplateRequest);
        return Mono.from(this.execute(client -> client.deleteIndexTemplate(deleteIndexTemplateRequestES))).map(AcknowledgedResponseBase::acknowledged);
    }

    public Mono<TemplateData> getTemplate(GetTemplateRequest getTemplateRequest) {
        Assert.notNull((Object)getTemplateRequest, (String)"getTemplateRequest must not be null");
        org.opensearch.client.opensearch.indices.GetTemplateRequest getTemplateRequestES = this.requestConverter.indicesGetTemplateRequest(getTemplateRequest);
        Mono getTemplateResponse = Mono.from(this.execute(client -> client.getTemplate(getTemplateRequestES)));
        return getTemplateResponse.flatMap(response -> {
            TemplateData templateData;
            if (response != null && (templateData = this.responseConverter.indicesGetTemplateData((GetTemplateResponse)response, getTemplateRequest.getTemplateName())) != null) {
                return Mono.just((Object)templateData);
            }
            return Mono.empty();
        });
    }

    public Mono<Boolean> existsTemplate(ExistsTemplateRequest existsTemplateRequest) {
        Assert.notNull((Object)existsTemplateRequest, (String)"existsTemplateRequest must not be null");
        org.opensearch.client.opensearch.indices.ExistsTemplateRequest existsTemplateRequestES = this.requestConverter.indicesExistsTemplateRequest(existsTemplateRequest);
        return Mono.from(this.execute(client -> client.existsTemplate(existsTemplateRequestES))).map(BooleanResponse::value);
    }

    public Mono<Boolean> deleteTemplate(org.springframework.data.elasticsearch.core.index.DeleteTemplateRequest deleteTemplateRequest) {
        Assert.notNull((Object)deleteTemplateRequest, (String)"deleteTemplateRequest must not be null");
        DeleteTemplateRequest deleteTemplateRequestES = this.requestConverter.indicesDeleteTemplateRequest(deleteTemplateRequest);
        return Mono.from(this.execute(client -> client.deleteTemplate(deleteTemplateRequestES))).map(AcknowledgedResponseBase::acknowledged);
    }

    public Flux<IndexInformation> getInformation(IndexCoordinates index) {
        GetIndexRequest request = this.requestConverter.indicesGetIndexRequest(index);
        return Mono.from(this.execute(client -> client.get(request))).map(this.responseConverter::indicesGetIndexInformations).flatMapMany(Flux::fromIterable);
    }

    public IndexCoordinates getIndexCoordinates() {
        return this.boundClass != null ? this.getIndexCoordinatesFor(this.boundClass) : Objects.requireNonNull(this.boundIndexCoordinates);
    }

    private IndexCoordinates getIndexCoordinatesFor(Class<?> clazz) {
        return ((ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(clazz)).getIndexCoordinates();
    }

    private Set<Alias> getAliasesFor(Class<?> clazz) {
        return ((ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(clazz)).getAliases();
    }

    private Class<?> checkForBoundClass() {
        if (this.boundClass == null) {
            throw new InvalidDataAccessApiUsageException("IndexOperations are not bound");
        }
        return this.boundClass;
    }
}

