/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.orhlc;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.opensearch.search.fetch.subphase.highlight.AbstractHighlighterBuilder;
import org.opensearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.query.highlight.Highlight;
import org.springframework.data.elasticsearch.core.query.highlight.HighlightCommonParameters;
import org.springframework.data.elasticsearch.core.query.highlight.HighlightField;
import org.springframework.data.elasticsearch.core.query.highlight.HighlightFieldParameters;
import org.springframework.data.elasticsearch.core.query.highlight.HighlightParameters;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class HighlightQueryBuilder {
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;

    public HighlightQueryBuilder(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext) {
        this.mappingContext = mappingContext;
    }

    public HighlightBuilder getHighlightBuilder(Highlight highlight, @Nullable Class<?> type) {
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        this.addParameters((HighlightCommonParameters)highlight.getParameters(), (AbstractHighlighterBuilder<?>)highlightBuilder, type);
        for (HighlightField highlightField : highlight.getFields()) {
            String mappedName = this.mapFieldName(highlightField.getName(), type);
            HighlightBuilder.Field field = new HighlightBuilder.Field(mappedName);
            this.addParameters((HighlightCommonParameters)highlightField.getParameters(), (AbstractHighlighterBuilder<?>)field, type);
            highlightBuilder.field(field);
        }
        return highlightBuilder;
    }

    private <P extends HighlightCommonParameters> void addParameters(P parameters, AbstractHighlighterBuilder<?> builder, @Nullable Class<?> type) {
        if (StringUtils.hasLength((String)parameters.getBoundaryChars())) {
            builder.boundaryChars(parameters.getBoundaryChars().toCharArray());
        }
        if (parameters.getBoundaryMaxScan() > -1) {
            builder.boundaryMaxScan(Integer.valueOf(parameters.getBoundaryMaxScan()));
        }
        if (StringUtils.hasLength((String)parameters.getBoundaryScanner())) {
            builder.boundaryScannerType(parameters.getBoundaryScanner());
        }
        if (StringUtils.hasLength((String)parameters.getBoundaryScannerLocale())) {
            builder.boundaryScannerLocale(parameters.getBoundaryScannerLocale());
        }
        if (parameters.getForceSource()) {
            builder.forceSource(Boolean.valueOf(true));
        }
        if (StringUtils.hasLength((String)parameters.getFragmenter())) {
            builder.fragmenter(parameters.getFragmenter());
        }
        if (parameters.getFragmentSize() > -1) {
            builder.fragmentSize(Integer.valueOf(parameters.getFragmentSize()));
        }
        if (parameters.getNoMatchSize() > -1) {
            builder.noMatchSize(Integer.valueOf(parameters.getNoMatchSize()));
        }
        if (parameters.getNumberOfFragments() > -1) {
            builder.numOfFragments(Integer.valueOf(parameters.getNumberOfFragments()));
        }
        if (StringUtils.hasLength((String)parameters.getOrder())) {
            builder.order(parameters.getOrder());
        }
        if (parameters.getPhraseLimit() > -1) {
            builder.phraseLimit(Integer.valueOf(parameters.getPhraseLimit()));
        }
        if (parameters.getPreTags().length > 0) {
            builder.preTags(parameters.getPreTags());
        }
        if (parameters.getPostTags().length > 0) {
            builder.postTags(parameters.getPostTags());
        }
        if (!parameters.getRequireFieldMatch()) {
            builder.requireFieldMatch(Boolean.valueOf(false));
        }
        if (StringUtils.hasLength((String)parameters.getType())) {
            builder.highlighterType(parameters.getType());
        }
        if (builder instanceof HighlightBuilder && parameters instanceof HighlightParameters) {
            HighlightBuilder highlightBuilder = (HighlightBuilder)builder;
            HighlightParameters highlightParameters = (HighlightParameters)parameters;
            if (StringUtils.hasLength((String)highlightParameters.getEncoder())) {
                highlightBuilder.encoder(highlightParameters.getEncoder());
            }
            if (StringUtils.hasLength((String)highlightParameters.getTagsSchema())) {
                highlightBuilder.tagsSchema(highlightParameters.getTagsSchema());
            }
        }
        if (builder instanceof HighlightBuilder.Field && parameters instanceof HighlightFieldParameters) {
            HighlightBuilder.Field field = (HighlightBuilder.Field)builder;
            HighlightFieldParameters fieldParameters = (HighlightFieldParameters)parameters;
            if (fieldParameters.getFragmentOffset() > -1) {
                field.fragmentOffset(fieldParameters.getFragmentOffset());
            }
            if (fieldParameters.getMatchedFields().length > 0) {
                field.matchedFields(Arrays.stream(fieldParameters.getMatchedFields()).map(fieldName -> this.mapFieldName((String)fieldName, type)).collect(Collectors.toList()).toArray(new String[0]));
            }
        }
    }

    private String mapFieldName(String fieldName, @Nullable Class<?> type) {
        ElasticsearchPersistentProperty persistentProperty;
        ElasticsearchPersistentEntity persistentEntity;
        if (type != null && (persistentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(type)) != null && (persistentProperty = (ElasticsearchPersistentProperty)persistentEntity.getPersistentProperty(fieldName)) != null) {
            return persistentProperty.getFieldName();
        }
        return fieldName;
    }
}

