/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.orhlc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.common.geo.GeoDistance;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.GeoBoundingBoxQueryBuilder;
import org.opensearch.index.query.GeoDistanceQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.springframework.data.elasticsearch.core.geo.GeoBox;
import org.springframework.data.elasticsearch.core.geo.GeoJson;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class CriteriaFilterProcessor {
    CriteriaFilterProcessor() {
    }

    @Nullable
    QueryBuilder createFilter(Criteria criteria) {
        ArrayList<Object> filterBuilders = new ArrayList<Object>();
        for (Criteria chainedCriteria : criteria.getCriteriaChain()) {
            if (chainedCriteria.isOr()) {
                BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
                this.queriesForEntries(chainedCriteria).forEach(arg_0 -> ((BoolQueryBuilder)boolQuery).should(arg_0));
                filterBuilders.add(boolQuery);
                continue;
            }
            if (chainedCriteria.isNegating()) {
                List<QueryBuilder> negationFilters = this.buildNegationFilter(criteria.getField().getName(), criteria.getFilterCriteriaEntries().iterator());
                filterBuilders.addAll(negationFilters);
                continue;
            }
            filterBuilders.addAll(this.queriesForEntries(chainedCriteria));
        }
        QueryBuilder filter = null;
        if (!filterBuilders.isEmpty()) {
            if (filterBuilders.size() == 1) {
                filter = (QueryBuilder)filterBuilders.get(0);
            } else {
                BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
                filterBuilders.forEach(arg_0 -> ((BoolQueryBuilder)boolQuery).must(arg_0));
                filter = boolQuery;
            }
        }
        return filter;
    }

    private List<QueryBuilder> queriesForEntries(Criteria criteria) {
        Assert.notNull((Object)criteria.getField(), (String)"criteria must have a field");
        String fieldName = criteria.getField().getName();
        Assert.notNull((Object)fieldName, (String)"Unknown field");
        return criteria.getFilterCriteriaEntries().stream().map(entry -> this.queryFor(entry.getKey(), entry.getValue(), fieldName)).collect(Collectors.toList());
    }

    @Nullable
    private QueryBuilder queryFor(Criteria.OperationKey key, Object value, String fieldName) {
        QueryBuilder filter = null;
        switch (key) {
            case WITHIN: {
                Assert.isTrue((boolean)(value instanceof Object[]), (String)"Value of a geo distance filter should be an array of two values.");
                filter = this.withinQuery(fieldName, (Object[])value);
                break;
            }
            case BBOX: {
                Assert.isTrue((boolean)(value instanceof Object[]), (String)"Value of a boundedBy filter should be an array of one or two values.");
                filter = this.boundingBoxQuery(fieldName, (Object[])value);
                break;
            }
            case GEO_INTERSECTS: {
                Assert.isTrue((boolean)(value instanceof GeoJson), (String)"value of a GEO_INTERSECTS filter must be a GeoJson object");
                filter = this.geoJsonQuery(fieldName, (GeoJson)value, "intersects");
                break;
            }
            case GEO_IS_DISJOINT: {
                Assert.isTrue((boolean)(value instanceof GeoJson), (String)"value of a GEO_IS_DISJOINT filter must be a GeoJson object");
                filter = this.geoJsonQuery(fieldName, (GeoJson)value, "disjoint");
                break;
            }
            case GEO_WITHIN: {
                Assert.isTrue((boolean)(value instanceof GeoJson), (String)"value of a GEO_WITHIN filter must be a GeoJson object");
                filter = this.geoJsonQuery(fieldName, (GeoJson)value, "within");
                break;
            }
            case GEO_CONTAINS: {
                Assert.isTrue((boolean)(value instanceof GeoJson), (String)"value of a GEO_CONTAINS filter must be a GeoJson object");
                filter = this.geoJsonQuery(fieldName, (GeoJson)value, "contains");
            }
        }
        return filter;
    }

    private QueryBuilder withinQuery(String fieldName, Object[] valArray) {
        GeoDistanceQueryBuilder filter = QueryBuilders.geoDistanceQuery((String)fieldName);
        Assert.noNullElements((Object[])valArray, (String)"Geo distance filter takes 2 not null elements array as parameter.");
        Assert.isTrue((valArray.length == 2 ? 1 : 0) != 0, (String)"Geo distance filter takes a 2-elements array as parameter.");
        Assert.isTrue((valArray[0] instanceof GeoPoint || valArray[0] instanceof String || valArray[0] instanceof Point ? 1 : 0) != 0, (String)"First element of a geo distance filter must be a GeoPoint, a Point or a text");
        Assert.isTrue((valArray[1] instanceof String || valArray[1] instanceof Distance ? 1 : 0) != 0, (String)"Second element of a geo distance filter must be a text or a Distance");
        StringBuilder dist = new StringBuilder();
        if (valArray[1] instanceof Distance) {
            this.extractDistanceString((Distance)valArray[1], dist);
        } else {
            dist.append((String)valArray[1]);
        }
        if (valArray[0] instanceof GeoPoint) {
            GeoPoint loc = (GeoPoint)valArray[0];
            filter.point(loc.getLat(), loc.getLon()).distance(dist.toString()).geoDistance(GeoDistance.PLANE);
        } else if (valArray[0] instanceof Point) {
            GeoPoint loc = GeoPoint.fromPoint((Point)((Point)valArray[0]));
            filter.point(loc.getLat(), loc.getLon()).distance(dist.toString()).geoDistance(GeoDistance.PLANE);
        } else {
            String loc = (String)valArray[0];
            if (loc.contains(",")) {
                String[] c = loc.split(",");
                filter.point(Double.parseDouble(c[0]), Double.parseDouble(c[1])).distance(dist.toString()).geoDistance(GeoDistance.PLANE);
            } else {
                filter.geohash(loc).distance(dist.toString()).geoDistance(GeoDistance.PLANE);
            }
        }
        return filter;
    }

    private QueryBuilder boundingBoxQuery(String fieldName, Object[] valArray) {
        Assert.noNullElements((Object[])valArray, (String)"Geo boundedBy filter takes a not null element array as parameter.");
        GeoBoundingBoxQueryBuilder filter = QueryBuilders.geoBoundingBoxQuery((String)fieldName);
        if (valArray.length == 1) {
            this.oneParameterBBox(filter, valArray[0]);
        } else if (valArray.length == 2) {
            this.twoParameterBBox(filter, valArray);
        } else {
            throw new IllegalArgumentException("Geo distance filter takes a 1-elements array(GeoBox) or 2-elements array(GeoPoints or Strings(format lat,lon or geohash)).");
        }
        return filter;
    }

    private QueryBuilder geoJsonQuery(String fieldName, GeoJson<?> geoJson, String relation) {
        return QueryBuilders.wrapperQuery((String)this.buildJsonQuery(fieldName, geoJson, relation));
    }

    private String buildJsonQuery(String fieldName, GeoJson<?> geoJson, String relation) {
        return "{\"geo_shape\": {\"" + fieldName + "\": {\"shape\": " + geoJson.toJson() + ", \"relation\": \"" + relation + "\"}}}";
    }

    private void extractDistanceString(Distance distance, StringBuilder sb) {
        sb.append((int)distance.getValue());
        Metrics metric = (Metrics)distance.getMetric();
        switch (metric) {
            case KILOMETERS: {
                sb.append("km");
                break;
            }
            case MILES: {
                sb.append("mi");
            }
        }
    }

    private void oneParameterBBox(GeoBoundingBoxQueryBuilder filter, Object value) {
        Assert.isTrue((value instanceof GeoBox || value instanceof Box ? 1 : 0) != 0, (String)"single-element of boundedBy filter must be type of GeoBox or Box");
        GeoBox geoBBox = value instanceof Box ? GeoBox.fromBox((Box)((Box)value)) : (GeoBox)value;
        filter.setCorners(geoBBox.getTopLeft().getLat(), geoBBox.getTopLeft().getLon(), geoBBox.getBottomRight().getLat(), geoBBox.getBottomRight().getLon());
    }

    private static boolean isType(Object[] array, Class<?> clazz) {
        for (Object o : array) {
            if (clazz.isInstance(o)) continue;
            return false;
        }
        return true;
    }

    private void twoParameterBBox(GeoBoundingBoxQueryBuilder filter, Object[] values) {
        Assert.isTrue((CriteriaFilterProcessor.isType(values, GeoPoint.class) || CriteriaFilterProcessor.isType(values, String.class) ? 1 : 0) != 0, (String)" both elements of boundedBy filter must be type of GeoPoint or text(format lat,lon or geohash)");
        if (values[0] instanceof GeoPoint) {
            GeoPoint topLeft = (GeoPoint)values[0];
            GeoPoint bottomRight = (GeoPoint)values[1];
            filter.setCorners(topLeft.getLat(), topLeft.getLon(), bottomRight.getLat(), bottomRight.getLon());
        } else {
            String topLeft = (String)values[0];
            String bottomRight = (String)values[1];
            filter.setCorners(topLeft, bottomRight);
        }
    }

    private List<QueryBuilder> buildNegationFilter(String fieldName, Iterator<Criteria.CriteriaEntry> it) {
        LinkedList<QueryBuilder> notFilterList = new LinkedList<QueryBuilder>();
        while (it.hasNext()) {
            Criteria.CriteriaEntry criteriaEntry = it.next();
            BoolQueryBuilder notFilter = QueryBuilders.boolQuery().mustNot(this.queryFor(criteriaEntry.getKey(), criteriaEntry.getValue(), fieldName));
            notFilterList.add((QueryBuilder)notFilter);
        }
        return notFilterList;
    }
}

