/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.osc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.data.client.osc.Aggregation;
import org.opensearch.data.client.osc.OpenSearchAggregation;
import org.springframework.data.elasticsearch.core.AggregationsContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class OpenSearchAggregations
implements AggregationsContainer<List<OpenSearchAggregation>> {
    private final List<OpenSearchAggregation> aggregations;
    private final Map<String, OpenSearchAggregation> aggregationsAsMap;

    public OpenSearchAggregations(Map<String, Aggregate> aggregations) {
        Assert.notNull(aggregations, (String)"aggregations must not be null");
        this.aggregationsAsMap = new HashMap<String, OpenSearchAggregation>();
        aggregations.forEach((name, aggregate) -> this.aggregationsAsMap.put((String)name, new OpenSearchAggregation(new Aggregation((String)name, (Aggregate)aggregate))));
        this.aggregations = new ArrayList<OpenSearchAggregation>(this.aggregationsAsMap.values());
    }

    public List<OpenSearchAggregation> aggregations() {
        return this.aggregations;
    }

    public Map<String, OpenSearchAggregation> aggregationsAsMap() {
        return this.aggregationsAsMap;
    }

    @Nullable
    public OpenSearchAggregation get(String name) {
        Assert.notNull((Object)name, (String)"name must not be null");
        return this.aggregationsAsMap.get(name);
    }
}

