/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.osc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.opensearch._types.ShardStatistics;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch.core.SearchTemplateResponse;
import org.opensearch.client.opensearch.core.search.CompletionSuggest;
import org.opensearch.client.opensearch.core.search.CompletionSuggestOption;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.HitsMetadata;
import org.opensearch.client.opensearch.core.search.PhraseSuggest;
import org.opensearch.client.opensearch.core.search.SearchResult;
import org.opensearch.client.opensearch.core.search.Suggest;
import org.opensearch.client.opensearch.core.search.TermSuggest;
import org.opensearch.client.opensearch.core.search.TotalHits;
import org.opensearch.data.client.osc.DocumentAdapters;
import org.opensearch.data.client.osc.EntityAsMap;
import org.opensearch.data.client.osc.OpenSearchAggregations;
import org.opensearch.data.client.osc.ResponseConverter;
import org.springframework.data.elasticsearch.ElasticsearchErrorCause;
import org.springframework.data.elasticsearch.core.AggregationsContainer;
import org.springframework.data.elasticsearch.core.SearchShardStatistics;
import org.springframework.data.elasticsearch.core.TotalHitsRelation;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.data.elasticsearch.core.suggest.response.CompletionSuggestion;
import org.springframework.data.elasticsearch.core.suggest.response.PhraseSuggestion;
import org.springframework.data.elasticsearch.core.suggest.response.TermSuggestion;
import org.springframework.data.elasticsearch.support.ScoreDoc;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

class SearchDocumentResponseBuilder {
    private static final Log LOGGER = LogFactory.getLog(SearchDocumentResponseBuilder.class);

    SearchDocumentResponseBuilder() {
    }

    public static <T> SearchDocumentResponse from(SearchResult<EntityAsMap> responseBody, SearchDocumentResponse.EntityCreator<T> entityCreator, JsonpMapper jsonpMapper) {
        Assert.notNull(responseBody, (String)"responseBody must not be null");
        Assert.notNull(entityCreator, (String)"entityCreator must not be null");
        Assert.notNull((Object)jsonpMapper, (String)"jsonpMapper must not be null");
        HitsMetadata hitsMetadata = responseBody.hits();
        String scrollId = responseBody.scrollId();
        Map aggregations = responseBody.aggregations();
        Map suggest = responseBody.suggest();
        String pointInTimeId = responseBody.pitId();
        ShardStatistics shards = responseBody.shards();
        return SearchDocumentResponseBuilder.from(hitsMetadata, shards, scrollId, pointInTimeId, aggregations, suggest, entityCreator, jsonpMapper);
    }

    public static <T> SearchDocumentResponse from(SearchTemplateResponse<EntityAsMap> response, SearchDocumentResponse.EntityCreator<T> entityCreator, JsonpMapper jsonpMapper) {
        Assert.notNull(response, (String)"response must not be null");
        Assert.notNull(entityCreator, (String)"entityCreator must not be null");
        Assert.notNull((Object)jsonpMapper, (String)"jsonpMapper must not be null");
        HitsMetadata hitsMetadata = response.hits();
        String scrollId = response.scrollId();
        Map aggregations = response.aggregations();
        Map suggest = response.suggest();
        String pointInTimeId = response.pitId();
        ShardStatistics shards = response.shards();
        return SearchDocumentResponseBuilder.from(hitsMetadata, shards, scrollId, pointInTimeId, aggregations, suggest, entityCreator, jsonpMapper);
    }

    public static <T> SearchDocumentResponse from(HitsMetadata<?> hitsMetadata, @Nullable ShardStatistics shards, @Nullable String scrollId, @Nullable String pointInTimeId, @Nullable Map<String, Aggregate> aggregations, Map<String, List<Suggest<EntityAsMap>>> suggestES, SearchDocumentResponse.EntityCreator<T> entityCreator, JsonpMapper jsonpMapper) {
        String totalHitsRelation;
        long totalHits;
        Assert.notNull(hitsMetadata, (String)"hitsMetadata must not be null");
        TotalHits responseTotalHits = hitsMetadata.total();
        if (responseTotalHits != null) {
            totalHits = responseTotalHits.value();
            totalHitsRelation = switch (responseTotalHits.relation().jsonValue()) {
                case "eq" -> TotalHitsRelation.EQUAL_TO.name();
                case "gte" -> TotalHitsRelation.GREATER_THAN_OR_EQUAL_TO.name();
                default -> TotalHitsRelation.OFF.name();
            };
        } else {
            totalHits = hitsMetadata.hits().size();
            totalHitsRelation = "OFF";
        }
        float maxScore = hitsMetadata.maxScore() != null ? hitsMetadata.maxScore().floatValue() : Float.NaN;
        ArrayList<SearchDocument> searchDocuments = new ArrayList<SearchDocument>();
        for (Hit hit : hitsMetadata.hits()) {
            searchDocuments.add(DocumentAdapters.from(hit, jsonpMapper));
        }
        OpenSearchAggregations aggregationsContainer = aggregations != null ? new OpenSearchAggregations(aggregations) : null;
        org.springframework.data.elasticsearch.core.suggest.response.Suggest suggest = SearchDocumentResponseBuilder.suggestFrom(suggestES, entityCreator);
        SearchShardStatistics shardStatistics = shards != null ? SearchDocumentResponseBuilder.shardsFrom(shards) : null;
        return new SearchDocumentResponse(totalHits, totalHitsRelation, maxScore, scrollId, pointInTimeId, searchDocuments, (AggregationsContainer)aggregationsContainer, suggest, shardStatistics);
    }

    private static SearchShardStatistics shardsFrom(ShardStatistics shards) {
        List failures = shards.failures();
        List<SearchShardStatistics.Failure> searchFailures = failures.stream().map(f -> SearchShardStatistics.Failure.of((String)f.index(), (String)f.node(), (String)f.status(), (int)f.shard(), null, (ElasticsearchErrorCause)ResponseConverter.toErrorCause(f.reason()))).toList();
        return SearchShardStatistics.of((Number)shards.failed(), (Number)shards.successful(), (Number)shards.total(), (Number)shards.skipped(), searchFailures);
    }

    @Nullable
    private static <T> org.springframework.data.elasticsearch.core.suggest.response.Suggest suggestFrom(Map<String, List<Suggest<EntityAsMap>>> suggestES, SearchDocumentResponse.EntityCreator<T> entityCreator) {
        if (CollectionUtils.isEmpty(suggestES)) {
            return null;
        }
        ArrayList suggestions = new ArrayList();
        suggestES.forEach((name, suggestionsES) -> {
            if (!suggestionsES.isEmpty()) {
                switch (((Suggest)suggestionsES.get(0))._kind()) {
                    case Term: {
                        suggestions.add(SearchDocumentResponseBuilder.getTermSuggestion(name, suggestionsES));
                        break;
                    }
                    case Phrase: {
                        suggestions.add(SearchDocumentResponseBuilder.getPhraseSuggestion(name, suggestionsES));
                        break;
                    }
                    case Completion: {
                        suggestions.add(SearchDocumentResponseBuilder.getCompletionSuggestion(name, suggestionsES, entityCreator));
                        break;
                    }
                }
            }
        });
        boolean hasScoreDocs = false;
        return new org.springframework.data.elasticsearch.core.suggest.response.Suggest(suggestions, hasScoreDocs);
    }

    private static TermSuggestion getTermSuggestion(String name, List<Suggest<EntityAsMap>> suggestionsES) {
        ArrayList entries = new ArrayList();
        suggestionsES.forEach(suggestionES -> {
            TermSuggest termSuggest = suggestionES.term();
            List termSuggestOptions = termSuggest.options();
            ArrayList options = new ArrayList();
            termSuggestOptions.forEach(optionES -> options.add(new TermSuggestion.Entry.Option(optionES.text(), null, optionES.score(), null, Math.toIntExact(optionES.freq()))));
            entries.add(new TermSuggestion.Entry(termSuggest.text(), termSuggest.offset(), termSuggest.length(), options));
        });
        return new TermSuggestion(name, suggestionsES.size(), entries, null);
    }

    private static PhraseSuggestion getPhraseSuggestion(String name, List<Suggest<EntityAsMap>> suggestionsES) {
        ArrayList entries = new ArrayList();
        suggestionsES.forEach(suggestionES -> {
            PhraseSuggest phraseSuggest = suggestionES.phrase();
            List phraseSuggestOptions = phraseSuggest.options();
            ArrayList options = new ArrayList();
            phraseSuggestOptions.forEach(optionES -> options.add(new PhraseSuggestion.Entry.Option(optionES.text(), optionES.highlighted(), Double.valueOf(optionES.score()), optionES.collateMatch())));
            entries.add(new PhraseSuggestion.Entry(phraseSuggest.text(), phraseSuggest.offset(), phraseSuggest.length(), options, null));
        });
        return new PhraseSuggestion(name, suggestionsES.size(), entries);
    }

    private static <T> CompletionSuggestion<T> getCompletionSuggestion(String name, List<Suggest<EntityAsMap>> suggestionsES, SearchDocumentResponse.EntityCreator<T> entityCreator) {
        ArrayList entries = new ArrayList();
        suggestionsES.forEach(suggestionES -> {
            CompletionSuggest completionSuggest = suggestionES.completion();
            ArrayList options = new ArrayList();
            List optionsES = completionSuggest.options();
            optionsES.forEach(optionES -> {
                Object hitEntity;
                SearchDocument searchDocument;
                block3: {
                    searchDocument = optionES.source() != null ? DocumentAdapters.from((CompletionSuggestOption<EntityAsMap>)optionES) : null;
                    hitEntity = null;
                    if (searchDocument != null) {
                        try {
                            hitEntity = ((CompletableFuture)entityCreator.apply((Object)searchDocument)).get();
                        }
                        catch (Exception e) {
                            if (!LOGGER.isWarnEnabled()) break block3;
                            LOGGER.warn((Object)("Error creating entity from SearchDocument: " + e.getMessage()));
                        }
                    }
                }
                HashMap contexts = new HashMap();
                optionES.contexts().forEach((key, contextList) -> contexts.put(key, contextList.stream().map(context -> context._get().toString()).collect(Collectors.toSet())));
                options.add(new CompletionSuggestion.Entry.Option(optionES.text(), null, Double.valueOf(optionES.score()), Boolean.valueOf(optionES.collateMatch() != null ? optionES.collateMatch() : false), contexts, new ScoreDoc(optionES.score(), null, null), searchDocument, hitEntity));
            });
            entries.add(new CompletionSuggestion.Entry(completionSuggest.text(), completionSuggest.offset(), completionSuggest.length(), options));
        });
        return new CompletionSuggestion(name, suggestionsES.size(), entries);
    }
}

