/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.data.client.osc;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.opensearch.core.MgetResponse;
import org.opensearch.client.opensearch.core.explain.ExplanationDetail;
import org.opensearch.client.opensearch.core.get.GetResult;
import org.opensearch.client.opensearch.core.mget.MultiGetResponseItem;
import org.opensearch.client.opensearch.core.search.CompletionSuggestOption;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.NestedIdentity;
import org.opensearch.data.client.osc.EntityAsMap;
import org.opensearch.data.client.osc.ResponseConverter;
import org.opensearch.data.client.osc.SearchDocumentResponseBuilder;
import org.springframework.data.elasticsearch.core.MultiGetItem;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.document.Explanation;
import org.springframework.data.elasticsearch.core.document.NestedMetaData;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.document.SearchDocumentAdapter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

final class DocumentAdapters {
    private static final Log LOGGER = LogFactory.getLog(DocumentAdapters.class);

    private DocumentAdapters() {
    }

    public static SearchDocument from(Hit<?> hit, JsonpMapper jsonpMapper) {
        Document document;
        Assert.notNull(hit, (String)"hit must not be null");
        Map highlightFields = hit.highlight();
        LinkedHashMap innerHits = new LinkedHashMap();
        hit.innerHits().forEach((name, innerHitsResult) -> innerHits.put(name, SearchDocumentResponseBuilder.from(innerHitsResult.hits(), null, null, null, null, null, searchDocument -> null, jsonpMapper)));
        NestedMetaData nestedMetaData = DocumentAdapters.from(hit.nested());
        Explanation explanation = DocumentAdapters.from(hit.explanation());
        List matchedQueries = hit.matchedQueries();
        Function<Map, EntityAsMap> fromFields = fields -> {
            StringBuilder sb = new StringBuilder("{");
            boolean[] firstField = new boolean[]{true};
            hit.fields().forEach((key, jsonData) -> {
                if (!firstField[0]) {
                    sb.append(',');
                }
                sb.append('\"').append((String)key).append("\":").append(jsonData.toJson(jsonpMapper).toString());
                firstField[0] = false;
            });
            sb.append('}');
            return (EntityAsMap)new EntityAsMap().fromJson(sb.toString());
        };
        EntityAsMap hitFieldsAsMap = fromFields.apply(hit.fields());
        LinkedHashMap documentFields = new LinkedHashMap();
        hitFieldsAsMap.forEach((key, value) -> {
            if (value instanceof List) {
                documentFields.put(key, (List)value);
            } else {
                documentFields.put(key, Collections.singletonList(value));
            }
        });
        Object source = hit.source();
        if (source == null) {
            document = Document.from((Map)((Object)hitFieldsAsMap));
        } else if (source instanceof EntityAsMap) {
            EntityAsMap entityAsMap = (EntityAsMap)((Object)source);
            document = Document.from((Map)((Object)entityAsMap));
        } else if (source instanceof JsonData) {
            JsonData jsonData = (JsonData)source;
            document = Document.from((Map)((Map)jsonData.to(EntityAsMap.class)));
        } else {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn((Object)String.format("Cannot map from type " + source.getClass().getName(), new Object[0]));
            }
            document = Document.create();
        }
        document.setIndex(hit.index());
        document.setId(hit.id());
        if (hit.version() != null) {
            document.setVersion(hit.version().longValue());
        }
        document.setSeqNo(hit.seqNo() != null && hit.seqNo() >= 0L ? hit.seqNo() : -2L);
        document.setPrimaryTerm(hit.primaryTerm() != null && hit.primaryTerm() > 0L ? hit.primaryTerm() : 0L);
        float score = hit.score() != null ? hit.score().floatValue() : Float.NaN;
        return new SearchDocumentAdapter(document, score, hit.sort().stream().toArray(), documentFields, highlightFields, innerHits, nestedMetaData, explanation, matchedQueries, hit.routing());
    }

    public static SearchDocument from(CompletionSuggestOption<EntityAsMap> completionSuggestOption) {
        Document document = completionSuggestOption.source() != null ? Document.from((Map)((Map)completionSuggestOption.source())) : Document.create();
        document.setIndex(completionSuggestOption.index());
        if (completionSuggestOption.id() != null) {
            document.setId(completionSuggestOption.id());
        }
        float score = (float)completionSuggestOption.score();
        return new SearchDocumentAdapter(document, score, new Object[0], Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), null, null, null, completionSuggestOption.routing());
    }

    @Nullable
    private static Explanation from(@Nullable org.opensearch.client.opensearch.core.explain.Explanation explanation) {
        if (explanation == null) {
            return null;
        }
        List details = explanation.details().stream().map(DocumentAdapters::from).collect(Collectors.toList());
        return new Explanation(Boolean.valueOf(true), Double.valueOf(explanation.value()), explanation.description(), details);
    }

    private static Explanation from(ExplanationDetail explanationDetail) {
        List details = explanationDetail.details().stream().map(DocumentAdapters::from).collect(Collectors.toList());
        return new Explanation(null, Double.valueOf(explanationDetail.value()), explanationDetail.description(), details);
    }

    @Nullable
    private static NestedMetaData from(@Nullable NestedIdentity nestedIdentity) {
        if (nestedIdentity == null) {
            return null;
        }
        NestedMetaData child = DocumentAdapters.from(nestedIdentity.nested());
        return NestedMetaData.of((String)nestedIdentity.field(), (int)nestedIdentity.offset(), (NestedMetaData)child);
    }

    @Nullable
    public static Document from(GetResult<EntityAsMap> getResponse) {
        Assert.notNull(getResponse, (String)"getResponse must not be null");
        if (!getResponse.found()) {
            return null;
        }
        Document document = getResponse.source() != null ? Document.from((Map)((Map)getResponse.source())) : Document.create();
        document.setIndex(getResponse.index());
        document.setId(getResponse.id());
        if (getResponse.version() != null) {
            document.setVersion(getResponse.version().longValue());
        }
        if (getResponse.seqNo() != null) {
            document.setSeqNo(getResponse.seqNo().longValue());
        }
        if (getResponse.primaryTerm() != null) {
            document.setPrimaryTerm(getResponse.primaryTerm().longValue());
        }
        return document;
    }

    public static List<MultiGetItem<Document>> from(MgetResponse<EntityAsMap> mgetResponse) {
        Assert.notNull(mgetResponse, (String)"mgetResponse must not be null");
        return mgetResponse.docs().stream().map(itemResponse -> MultiGetItem.of((Object)(itemResponse.isFailure() ? null : DocumentAdapters.from((GetResult<EntityAsMap>)itemResponse.result())), (MultiGetItem.Failure)ResponseConverter.getFailure((MultiGetResponseItem<EntityAsMap>)itemResponse))).collect(Collectors.toList());
    }
}

