/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.spring.boot.autoconfigure;

import java.util.List;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.spring.boot.autoconfigure.OpenSearchConnectionDetails;
import org.opensearch.spring.boot.autoconfigure.OpenSearchProperties;
import org.opensearch.spring.boot.autoconfigure.OpenSearchRestClientConfigurations;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@AutoConfiguration
@ConditionalOnClass(value={RestClientBuilder.class})
@EnableConfigurationProperties(value={OpenSearchProperties.class})
@Import(value={OpenSearchRestClientConfigurations.RestClientBuilderConfiguration.class, OpenSearchRestClientConfigurations.RestClientConfiguration.class, OpenSearchRestClientConfigurations.RestClientSnifferConfiguration.class})
public class OpenSearchRestClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={OpenSearchConnectionDetails.class})
    OpenSearchConnectionDetails openSearchConnectionDetails(OpenSearchProperties properties) {
        return new PropertiesOpenSearchConnectionDetails(properties);
    }

    static class PropertiesOpenSearchConnectionDetails
    implements OpenSearchConnectionDetails {
        private final OpenSearchProperties properties;

        PropertiesOpenSearchConnectionDetails(OpenSearchProperties properties) {
            this.properties = properties;
        }

        @Override
        public List<String> getUris() {
            return this.properties.getUris();
        }

        @Override
        public String getUsername() {
            return this.properties.getUsername();
        }

        @Override
        public String getPassword() {
            return this.properties.getPassword();
        }

        @Override
        public String getPathPrefix() {
            return this.properties.getPathPrefix();
        }
    }
}

