/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.NodeAttributes;
import org.opensearch.client.opensearch._types.NodeShard;
import org.opensearch.client.opensearch.core.search_shards.ShardStoreIndex;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class SearchShardsResponse
implements PlainJsonSerializable {
    private final Map<String, NodeAttributes> nodes;
    private final List<List<NodeShard>> shards;
    private final Map<String, ShardStoreIndex> indices;
    public static final JsonpDeserializer<SearchShardsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchShardsResponse::setupSearchShardsResponseDeserializer);

    private SearchShardsResponse(Builder builder) {
        this.nodes = ApiTypeHelper.unmodifiableRequired(builder.nodes, (Object)this, "nodes");
        this.shards = ApiTypeHelper.unmodifiableRequired(builder.shards, (Object)this, "shards");
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
    }

    public static SearchShardsResponse of(Function<Builder, ObjectBuilder<SearchShardsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, NodeAttributes> nodes() {
        return this.nodes;
    }

    public final List<List<NodeShard>> shards() {
        return this.shards;
    }

    public final Map<String, ShardStoreIndex> indices() {
        return this.indices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.nodes)) {
            generator.writeKey("nodes");
            generator.writeStartObject();
            for (Map.Entry entry : this.nodes.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((NodeAttributes)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.shards)) {
            generator.writeKey("shards");
            generator.writeStartArray();
            for (List list : this.shards) {
                generator.writeStartArray();
                if (list != null) {
                    for (NodeShard item1 : list) {
                        item1.serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartObject();
            for (Map.Entry entry : this.indices.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((ShardStoreIndex)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupSearchShardsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(NodeAttributes._DESERIALIZER), "nodes");
        op.add(Builder::shards, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.arrayDeserializer(NodeShard._DESERIALIZER)), "shards");
        op.add(Builder::indices, JsonpDeserializer.stringMapDeserializer(ShardStoreIndex._DESERIALIZER), "indices");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SearchShardsResponse> {
        private Map<String, NodeAttributes> nodes;
        private List<List<NodeShard>> shards;
        private Map<String, ShardStoreIndex> indices;

        public final Builder nodes(Map<String, NodeAttributes> map) {
            this.nodes = Builder._mapPutAll(this.nodes, map);
            return this;
        }

        public final Builder nodes(String key, NodeAttributes value) {
            this.nodes = Builder._mapPut(this.nodes, key, value);
            return this;
        }

        public final Builder nodes(String key, Function<NodeAttributes.Builder, ObjectBuilder<NodeAttributes>> fn) {
            return this.nodes(key, fn.apply(new NodeAttributes.Builder()).build());
        }

        public final Builder shards(List<List<NodeShard>> list) {
            this.shards = Builder._listAddAll(this.shards, list);
            return this;
        }

        public final Builder shards(List<NodeShard> value, List<NodeShard> ... values) {
            this.shards = Builder._listAdd(this.shards, value, values);
            return this;
        }

        public final Builder indices(Map<String, ShardStoreIndex> map) {
            this.indices = Builder._mapPutAll(this.indices, map);
            return this;
        }

        public final Builder indices(String key, ShardStoreIndex value) {
            this.indices = Builder._mapPut(this.indices, key, value);
            return this;
        }

        public final Builder indices(String key, Function<ShardStoreIndex.Builder, ObjectBuilder<ShardStoreIndex>> fn) {
            return this.indices(key, fn.apply(new ShardStoreIndex.Builder()).build());
        }

        @Override
        public SearchShardsResponse build() {
            this._checkSingleUse();
            return new SearchShardsResponse(this);
        }
    }
}

