/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

public class HybridQuery
extends QueryBase
implements QueryVariant {
    private final List<Query> queries;
    public static final JsonpDeserializer<HybridQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HybridQuery::setupHybridQueryDeserializer);

    private HybridQuery(Builder builder) {
        super(builder);
        this.queries = ApiTypeHelper.unmodifiable(builder.queries);
    }

    public static HybridQuery of(Function<Builder, ObjectBuilder<HybridQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Query> queries() {
        return this.queries;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("queries");
        generator.writeStartArray();
        for (Query item0 : this.queries) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Hybrid;
    }

    public Builder toBuilder() {
        return this.toBuilder(new Builder()).queries(this.queries);
    }

    protected static void setupHybridQueryDeserializer(ObjectDeserializer<Builder> op) {
        HybridQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::queries, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "queries");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HybridQuery> {
        private List<Query> queries;

        public final Builder queries(List<Query> list) {
            this.queries = Builder._listAddAll(this.queries, list);
            return this;
        }

        public final Builder queries(Query value, Query ... values) {
            this.queries = Builder._listAdd(this.queries, value, values);
            return this;
        }

        public final Builder queries(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.queries(fn.apply(new Query.Builder()).build(), new Query[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HybridQuery build() {
            this._checkSingleUse();
            return new HybridQuery(this);
        }
    }
}

