/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.util.ObjectBuilder;

// typedef: _types.mapping.VersionProperty

@JsonpDeserializable
public class VersionProperty extends DocValuesPropertyBase implements PropertyVariant {
    // ---------------------------------------------------------------------------------------------

    private VersionProperty(Builder builder) {
        super(builder);

    }

    public static VersionProperty of(Function<Builder, ObjectBuilder<VersionProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    /**
     * Property variant kind.
     */
    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Version;
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {

        generator.write("type", "version");
        super.serializeInternal(generator, mapper);

    }

    // ---------------------------------------------------------------------------------------------

    /**
     * Builder for {@link VersionProperty}.
     */

    public static class Builder extends DocValuesPropertyBase.AbstractBuilder<Builder> implements ObjectBuilder<VersionProperty> {
        @Override
        protected Builder self() {
            return this;
        }

        /**
         * Builds a {@link VersionProperty}.
         *
         * @throws NullPointerException
         *             if some of the required fields are null.
         */
        public VersionProperty build() {
            _checkSingleUse();

            return new VersionProperty(this);
        }
    }

    // ---------------------------------------------------------------------------------------------

    /**
     * Json deserializer for {@link VersionProperty}
     */
    public static final JsonpDeserializer<VersionProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(
        Builder::new,
        VersionProperty::setupVersionPropertyDeserializer
    );

    protected static void setupVersionPropertyDeserializer(ObjectDeserializer<VersionProperty.Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);

        op.ignore("type");
    }

}
