/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.snapshot;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.snapshot.SnapshotInfo;
import org.opensearch.client.opensearch.snapshot.get.SnapshotResponseItem;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class GetSnapshotResponse
implements PlainJsonSerializable {
    private final List<SnapshotResponseItem> responses;
    private final List<SnapshotInfo> snapshots;
    private final int total;
    private final int remaining;
    public static final JsonpDeserializer<GetSnapshotResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetSnapshotResponse::setupGetSnapshotResponseDeserializer);

    private GetSnapshotResponse(Builder builder) {
        this.responses = ApiTypeHelper.unmodifiable(builder.responses);
        this.snapshots = ApiTypeHelper.unmodifiable(builder.snapshots);
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.remaining = ApiTypeHelper.requireNonNull(builder.remaining, this, "remaining");
    }

    public static GetSnapshotResponse of(Function<Builder, ObjectBuilder<GetSnapshotResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<SnapshotResponseItem> responses() {
        return this.responses;
    }

    public final List<SnapshotInfo> snapshots() {
        return this.snapshots;
    }

    public final int total() {
        return this.total;
    }

    public final int remaining() {
        return this.remaining;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.responses)) {
            generator.writeKey("responses");
            generator.writeStartArray();
            for (SnapshotResponseItem snapshotResponseItem : this.responses) {
                snapshotResponseItem.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.snapshots)) {
            generator.writeKey("snapshots");
            generator.writeStartArray();
            for (SnapshotInfo snapshotInfo : this.snapshots) {
                snapshotInfo.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("remaining");
        generator.write(this.remaining);
    }

    protected static void setupGetSnapshotResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::responses, JsonpDeserializer.arrayDeserializer(SnapshotResponseItem._DESERIALIZER), "responses");
        op.add(Builder::snapshots, JsonpDeserializer.arrayDeserializer(SnapshotInfo._DESERIALIZER), "snapshots");
        op.add(Builder::total, JsonpDeserializer.integerDeserializer(), "total");
        op.add(Builder::remaining, JsonpDeserializer.integerDeserializer(), "remaining");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GetSnapshotResponse> {
        @Nullable
        private List<SnapshotResponseItem> responses;
        @Nullable
        private List<SnapshotInfo> snapshots;
        private Integer total;
        private Integer remaining;

        public final Builder responses(List<SnapshotResponseItem> list) {
            this.responses = Builder._listAddAll(this.responses, list);
            return this;
        }

        public final Builder responses(SnapshotResponseItem value, SnapshotResponseItem ... values) {
            this.responses = Builder._listAdd(this.responses, value, values);
            return this;
        }

        public final Builder responses(Function<SnapshotResponseItem.Builder, ObjectBuilder<SnapshotResponseItem>> fn) {
            return this.responses(fn.apply(new SnapshotResponseItem.Builder()).build(), new SnapshotResponseItem[0]);
        }

        public final Builder snapshots(List<SnapshotInfo> list) {
            this.snapshots = Builder._listAddAll(this.snapshots, list);
            return this;
        }

        public final Builder snapshots(SnapshotInfo value, SnapshotInfo ... values) {
            this.snapshots = Builder._listAdd(this.snapshots, value, values);
            return this;
        }

        public final Builder snapshots(Function<SnapshotInfo.Builder, ObjectBuilder<SnapshotInfo>> fn) {
            return this.snapshots(fn.apply(new SnapshotInfo.Builder()).build(), new SnapshotInfo[0]);
        }

        public final Builder total(int value) {
            this.total = value;
            return this;
        }

        public final Builder remaining(int value) {
            this.remaining = value;
            return this;
        }

        @Override
        public GetSnapshotResponse build() {
            this._checkSingleUse();
            return new GetSnapshotResponse(this);
        }
    }
}

