/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.info;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.IndexRouting;
import org.opensearch.client.opensearch.nodes.info.NodeInfoSettingsClusterElection;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class NodeInfoSettingsCluster
implements PlainJsonSerializable {
    private final String name;
    @Nullable
    private final IndexRouting routing;
    @Nullable
    private final NodeInfoSettingsClusterElection election;
    @Deprecated
    @Nullable
    private final List<String> initialMasterNodes;
    @Nullable
    private final List<String> initialClusterManagerNodes;
    public static final JsonpDeserializer<NodeInfoSettingsCluster> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoSettingsCluster::setupNodeInfoSettingsClusterDeserializer);

    private NodeInfoSettingsCluster(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.routing = builder.routing;
        this.election = builder.election;
        this.initialMasterNodes = builder.initialMasterNodes;
        this.initialClusterManagerNodes = builder.initialClusterManagerNodes;
    }

    public static NodeInfoSettingsCluster of(Function<Builder, ObjectBuilder<NodeInfoSettingsCluster>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final IndexRouting routing() {
        return this.routing;
    }

    @Nullable
    public final NodeInfoSettingsClusterElection election() {
        return this.election;
    }

    @Deprecated
    @Nullable
    public final List<String> initialMasterNodes() {
        return this.initialMasterNodes;
    }

    @Nullable
    public final List<String> initialClusterManagerNodes() {
        return this.initialClusterManagerNodes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (this.routing != null) {
            generator.writeKey("routing");
            this.routing.serialize(generator, mapper);
        }
        generator.writeKey("election");
        this.election.serialize(generator, mapper);
        if (this.initialMasterNodes != null) {
            generator.writeStartArray("initial_master_nodes");
            this.initialMasterNodes.forEach(arg_0 -> ((JsonGenerator)generator).write(arg_0));
            generator.writeEnd();
        }
        if (this.initialClusterManagerNodes != null) {
            generator.writeStartArray("initial_cluster_manager_nodes");
            this.initialClusterManagerNodes.forEach(arg_0 -> ((JsonGenerator)generator).write(arg_0));
            generator.writeEnd();
        }
    }

    protected static void setupNodeInfoSettingsClusterDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::routing, IndexRouting._DESERIALIZER, "routing");
        op.add(Builder::election, NodeInfoSettingsClusterElection._DESERIALIZER, "election");
        op.add(Builder::initialMasterNodes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "initial_master_nodes");
        op.add(Builder::initialClusterManagerNodes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "initial_cluster_manager_nodes");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<NodeInfoSettingsCluster> {
        private String name;
        @Nullable
        private IndexRouting routing;
        @Nullable
        private NodeInfoSettingsClusterElection election;
        @Deprecated
        @Nullable
        private List<String> initialMasterNodes;
        @Nullable
        private List<String> initialClusterManagerNodes;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder routing(@Nullable IndexRouting value) {
            this.routing = value;
            return this;
        }

        public final Builder routing(Function<IndexRouting.Builder, ObjectBuilder<IndexRouting>> fn) {
            return this.routing(fn.apply(new IndexRouting.Builder()).build());
        }

        public final Builder election(NodeInfoSettingsClusterElection value) {
            this.election = value;
            return this;
        }

        public final Builder election(Function<NodeInfoSettingsClusterElection.Builder, ObjectBuilder<NodeInfoSettingsClusterElection>> fn) {
            return this.election(fn.apply(new NodeInfoSettingsClusterElection.Builder()).build());
        }

        @Deprecated
        public final Builder initialMasterNodes(@Nullable List<String> value) {
            this.initialMasterNodes = value;
            return this;
        }

        public final Builder initialClusterManagerNodes(@Nullable List<String> value) {
            this.initialClusterManagerNodes = value;
            return this;
        }

        @Override
        public NodeInfoSettingsCluster build() {
            this._checkSingleUse();
            return new NodeInfoSettingsCluster(this);
        }
    }
}

