/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.util.Hashtable;
import java.util.Map;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.tools.IValencyChecker;

public class CDKValencyChecker
implements IValencyChecker {
    private AtomTypeFactory atomTypeList;
    private static final String ATOM_TYPE_LIST = "org/openscience/cdk/dict/data/cdk-atom-types.owl";
    private static Map<String, CDKValencyChecker> tables = new Hashtable<String, CDKValencyChecker>(3);

    private CDKValencyChecker(IChemObjectBuilder builder) {
        if (this.atomTypeList == null) {
            this.atomTypeList = AtomTypeFactory.getInstance((String)ATOM_TYPE_LIST, (IChemObjectBuilder)builder);
        }
    }

    public static CDKValencyChecker getInstance(IChemObjectBuilder builder) {
        if (!tables.containsKey(builder.getClass().getName())) {
            tables.put(builder.getClass().getName(), new CDKValencyChecker(builder));
        }
        return tables.get(builder.getClass().getName());
    }

    @Override
    public boolean isSaturated(IAtomContainer atomContainer) throws CDKException {
        for (IAtom atom : atomContainer.atoms()) {
            if (this.isSaturated(atom, atomContainer)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSaturated(IAtom atom, IAtomContainer container) throws CDKException {
        System.out.println(atom.getAtomTypeName());
        IAtomType type = this.atomTypeList.getAtomType(atom.getAtomTypeName());
        if (type == null) {
            throw new CDKException("Atom type is not a recognized CDK atom type: " + atom.getAtomTypeName());
        }
        if (type.getFormalNeighbourCount() == CDKConstants.UNSET) {
            throw new CDKException("Atom type is too general; cannot decide the number of implicit hydrogen to add for: " + atom.getAtomTypeName());
        }
        if (type.getProperty((Object)"cdk:Pi Bond Count") == CDKConstants.UNSET) {
            throw new CDKException("Atom type is too general; cannot determine the number of pi bonds for: " + atom.getAtomTypeName());
        }
        double bondOrderSum = container.getBondOrderSum(atom);
        IBond.Order maxBondOrder = container.getMaximumBondOrder(atom);
        Integer hcount = atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount();
        int piBondCount = (Integer)type.getProperty((Object)"cdk:Pi Bond Count");
        int formalNeighborCount = type.getFormalNeighbourCount();
        int typeMaxBondOrder = piBondCount + 1;
        int typeBondOrderSum = formalNeighborCount + piBondCount;
        return bondOrderSum + (double)hcount.intValue() == (double)typeBondOrderSum && maxBondOrder.numeric() <= typeMaxBondOrder;
    }
}

