/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.invariant;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.openscience.cdk.graph.invariant.InvariantRanker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IPseudoAtom;

public final class Canon {
    private static final int N_PRIMES = 10000;
    private final int[][] g;
    private final long[] labelling;
    private final long[] symmetry;
    private boolean symOnly = false;
    private static final int[] PRIMES = Canon.loadPrimes();

    private Canon(int[][] g, long[] partition, boolean[] hydrogens, boolean symOnly) {
        this.g = g;
        this.symOnly = symOnly;
        this.labelling = (long[])partition.clone();
        this.symmetry = this.refine(this.labelling, hydrogens);
    }

    public static long[] label(IAtomContainer container, int[][] g) {
        return Canon.label(container, g, Canon.basicInvariants(container, g));
    }

    public static long[] label(IAtomContainer container, int[][] g, long[] invariants) {
        if (invariants.length != g.length) {
            throw new IllegalArgumentException("number of invariants != number of atoms");
        }
        return new Canon((int[][])g, (long[])invariants, (boolean[])Canon.terminalHydrogens((IAtomContainer)container, (int[][])g), (boolean)false).labelling;
    }

    public static long[] symmetry(IAtomContainer container, int[][] g) {
        return new Canon((int[][])g, (long[])Canon.basicInvariants((IAtomContainer)container, (int[][])g), (boolean[])Canon.terminalHydrogens((IAtomContainer)container, (int[][])g), (boolean)true).symmetry;
    }

    private long[] refine(long[] invariants, boolean[] hydrogens) {
        int ord = this.g.length;
        InvariantRanker ranker = new InvariantRanker(ord);
        int[] currVs = new int[ord];
        int[] nextVs = new int[ord];
        int nnu = ord;
        for (int i = 0; i < ord; ++i) {
            currVs[i] = i;
        }
        long[] prev = invariants;
        long[] curr = Arrays.copyOf(invariants, ord);
        Arrays.fill(prev, 1L);
        int n = 0;
        int m = 0;
        long[] symmetry = null;
        while (n < ord) {
            int i;
            while ((n = ranker.rank(currVs, nextVs, nnu, curr, prev)) > m && n < ord) {
                nnu = 0;
                for (i = 0; i < ord && nextVs[i] >= 0; ++i) {
                    int v = nextVs[i];
                    currVs[nnu++] = v;
                    curr[v] = hydrogens[v] ? prev[v] : this.primeProduct(this.g[v], prev, hydrogens);
                }
                m = n;
            }
            if (symmetry == null) {
                for (i = 0; i < this.g.length; ++i) {
                    if (!hydrogens[i]) continue;
                    curr[i] = prev[this.g[i][0]];
                    hydrogens[i] = false;
                }
                n = ranker.rank(currVs, nextVs, nnu, curr, prev);
                symmetry = Arrays.copyOf(prev, ord);
                nnu = 0;
                for (i = 0; i < ord && nextVs[i] >= 0; ++i) {
                    currVs[nnu++] = nextVs[i];
                }
            }
            if (this.symOnly || n == ord) {
                return symmetry;
            }
            int lo = nextVs[0];
            for (int i2 = 1; i2 < ord && nextVs[i2] >= 0 && prev[nextVs[i2]] == prev[lo]; ++i2) {
                int n2 = nextVs[i2];
                prev[n2] = prev[n2] + 1L;
            }
            System.arraycopy(nextVs, 0, currVs, 0, nnu);
        }
        return symmetry;
    }

    private long primeProduct(int[] ws, long[] ranks, boolean[] hydrogens) {
        long prod = 1L;
        for (int w : ws) {
            if (hydrogens[w]) continue;
            prod *= (long)PRIMES[(int)ranks[w]];
        }
        return prod;
    }

    public static long[] basicInvariants(IAtomContainer container, int[][] graph) {
        long[] labels = new long[graph.length];
        for (int v = 0; v < graph.length; ++v) {
            IAtom atom = container.getAtom(v);
            int deg = graph[v].length;
            int impH = Canon.implH(atom);
            int expH = 0;
            int elem = Canon.atomicNumber(atom);
            int chg = Canon.charge(atom);
            for (int w : graph[v]) {
                if (Canon.atomicNumber(container.getAtom(w)) != 1) continue;
                ++expH;
            }
            long label = 0L;
            label |= (long)(deg + impH & 0xF);
            label <<= 4;
            label |= (long)(deg - expH & 0xF);
            label <<= 7;
            label |= (long)(elem & 0x7F);
            label <<= 1;
            label |= (long)(chg >> 31 & 1);
            label <<= 2;
            label |= (long)(Math.abs(chg) & 3);
            label <<= 4;
            labels[v] = label |= (long)(impH + expH & 0xF);
        }
        return labels;
    }

    private static int atomicNumber(IAtom atom) {
        Integer elem = atom.getAtomicNumber();
        if (elem != null) {
            return elem;
        }
        if (atom instanceof IPseudoAtom) {
            return 0;
        }
        throw new NullPointerException("a non-pseudoatom had unset atomic number");
    }

    private static int implH(IAtom atom) {
        Integer h = atom.getImplicitHydrogenCount();
        if (h != null) {
            return h;
        }
        if (atom instanceof IPseudoAtom) {
            return 0;
        }
        throw new NullPointerException("a non-pseudoatom had unset hydrogen count");
    }

    private static int charge(IAtom atom) {
        Integer charge = atom.getFormalCharge();
        if (charge != null) {
            return charge;
        }
        return 0;
    }

    static boolean[] terminalHydrogens(IAtomContainer ac, int[][] g) {
        boolean[] hydrogens = new boolean[ac.getAtomCount()];
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            IAtom atom = ac.getAtom(i);
            hydrogens[i] = atom.getAtomicNumber() == 1 && atom.getMassNumber() == null && g[i].length == 1;
        }
        return hydrogens;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int[] loadPrimes() {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Canon.class.getResourceAsStream("primes.dat")));){
            int[] primes = new int[10000];
            int i = 0;
            String line = null;
            while ((line = br.readLine()) != null) {
                primes[i++] = Integer.parseInt(line);
            }
            assert (i == 10000);
            int[] nArray = primes;
            return nArray;
        }
        catch (IOException | NumberFormatException e) {
            System.err.println("Critical - could not load primes table for canonical labelling!");
            return new int[0];
        }
    }
}

