/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.aromaticity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.CycleFinder;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.ringsearch.RingSearch;

public final class Aromaticity {
    private final ElectronDonation model;
    private final CycleFinder cycles;
    private static final Aromaticity CDK_LEGACY = new Aromaticity(ElectronDonation.cdk(), Cycles.cdkAromaticSet());

    public Aromaticity(ElectronDonation model, CycleFinder cycles) {
        this.model = (ElectronDonation)Preconditions.checkNotNull((Object)model);
        this.cycles = (CycleFinder)Preconditions.checkNotNull((Object)cycles);
    }

    public Set<IBond> findBonds(IAtomContainer molecule) throws CDKException {
        GraphUtil.EdgeToBondMap bondMap = GraphUtil.EdgeToBondMap.withSpaceFor((IAtomContainer)molecule);
        int[][] graph = GraphUtil.toAdjList((IAtomContainer)molecule, (GraphUtil.EdgeToBondMap)bondMap);
        RingSearch ringSearch = new RingSearch(molecule, graph);
        int[] electrons = this.model.contribution(molecule, ringSearch);
        HashSet bonds = Sets.newHashSetWithExpectedSize((int)molecule.getBondCount());
        int[] subset = Aromaticity.subset(electrons);
        int[][] subgraph = GraphUtil.subgraph((int[][])graph, (int[])subset);
        for (int[] cycle : this.cycles.find(molecule, subgraph, subgraph.length).paths()) {
            if (!Aromaticity.checkElectronSum(cycle, electrons, subset)) continue;
            for (int i = 1; i < cycle.length; ++i) {
                bonds.add(bondMap.get(subset[cycle[i]], subset[cycle[i - 1]]));
            }
        }
        return bonds;
    }

    public boolean apply(IAtomContainer molecule) throws CDKException {
        Set<IBond> bonds = this.findBonds(molecule);
        molecule.setFlag(32, false);
        for (IBond bond : molecule.bonds()) {
            bond.setIsAromatic(false);
        }
        for (IAtom atom : molecule.atoms()) {
            atom.setIsAromatic(false);
        }
        for (IBond bond : bonds) {
            bond.setIsAromatic(true);
            bond.getBegin().setIsAromatic(true);
            bond.getEnd().setIsAromatic(true);
        }
        molecule.setFlag(32, !bonds.isEmpty());
        return !bonds.isEmpty();
    }

    private static boolean checkElectronSum(int[] cycle, int[] contributions, int[] subset) {
        return Aromaticity.validSum(Aromaticity.electronSum(cycle, contributions, subset));
    }

    static int electronSum(int[] cycle, int[] contributions, int[] subset) {
        int sum = 0;
        for (int i = 1; i < cycle.length; ++i) {
            sum += contributions[subset[cycle[i]]];
        }
        return sum;
    }

    static boolean validSum(int sum) {
        return (sum - 2) % 4 == 0;
    }

    private static int[] subset(int[] electrons) {
        int[] vs = new int[electrons.length];
        int n = 0;
        for (int i = 0; i < electrons.length; ++i) {
            if (electrons[i] < 0) continue;
            vs[n++] = i;
        }
        return Arrays.copyOf(vs, n);
    }

    public static Aromaticity cdkLegacy() {
        return CDK_LEGACY;
    }
}

