/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.listener;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.ReaderEvent;
import org.openscience.cdk.io.listener.IReaderListener;
import org.openscience.cdk.io.listener.IWriterListener;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.io.setting.OptionIOSetting;

public class TextGUIListener
implements IReaderListener,
IWriterListener {
    private BufferedReader in;
    private PrintWriter out;
    private IOSetting.Importance level = IOSetting.Importance.HIGH;

    public TextGUIListener(IOSetting.Importance level) {
        this.level = level;
        this.setInputReader(new InputStreamReader(System.in));
        this.setOutputWriter(new OutputStreamWriter(System.out));
    }

    public void setLevel(IOSetting.Importance level) {
        this.level = level;
    }

    public void setOutputWriter(Writer writer) {
        this.out = writer instanceof PrintWriter ? (PrintWriter)writer : (writer == null ? null : new PrintWriter(writer));
    }

    public void setInputReader(Reader reader) {
        this.in = reader instanceof BufferedReader ? (BufferedReader)reader : (reader == null ? null : new BufferedReader(reader));
    }

    public void frameRead(ReaderEvent event) {
    }

    public void processIOSettingQuestion(IOSetting setting) {
        if (setting.getLevel().ordinal() <= this.level.ordinal()) {
            this.out.print("[" + setting.getName() + "]: ");
            this.out.print(setting.getQuestion());
            if (setting instanceof BooleanIOSetting) {
                BooleanIOSetting boolSet = (BooleanIOSetting)setting;
                boolean set = boolSet.isSet();
                if (set) {
                    this.out.print(" [Yn]");
                } else {
                    this.out.print(" [yN]");
                }
            } else if (setting instanceof OptionIOSetting) {
                OptionIOSetting optionSet = (OptionIOSetting)setting;
                List settings = optionSet.getOptions();
                for (int i = 0; i < settings.size(); ++i) {
                    this.out.println();
                    String option = (String)settings.get(i);
                    this.out.print(i + 1 + ". " + option);
                    if (!option.equals(setting.getSetting())) continue;
                    this.out.print(" (Default)");
                }
            } else {
                this.out.print(" [" + setting.getSetting() + "]");
            }
            this.out.println();
            this.out.flush();
            if (this.in != null) {
                boolean gotAnswer = false;
                while (!gotAnswer) {
                    try {
                        this.out.print("> ");
                        this.out.flush();
                        String answer = this.in.readLine();
                        if (answer.length() != 0) {
                            if (setting instanceof OptionIOSetting) {
                                ((OptionIOSetting)setting).setSetting(Integer.parseInt(answer));
                            } else if (setting instanceof BooleanIOSetting) {
                                if (answer.equalsIgnoreCase("n") || answer.equalsIgnoreCase("no")) {
                                    answer = "false";
                                }
                                if (answer.equalsIgnoreCase("y") || answer.equalsIgnoreCase("yes")) {
                                    answer = "true";
                                }
                                setting.setSetting(answer);
                            } else {
                                setting.setSetting(answer);
                            }
                        }
                        gotAnswer = true;
                    }
                    catch (IOException exception) {
                        this.out.println("Cannot read from STDIN. Skipping question.");
                    }
                    catch (NumberFormatException exception) {
                        this.out.println("Answer is not a number.");
                    }
                    catch (CDKException exception) {
                        this.out.println();
                        this.out.println(exception.toString());
                    }
                }
            }
        }
    }
}

