/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.util.Date;
import jcifs.Config;
import jcifs.smb.AndXServerMessageBlock;
import jcifs.smb.ServerMessageBlock;
import jcifs.util.Hexdump;

class SmbComOpenAndX
extends AndXServerMessageBlock {
    private static final int FLAGS_RETURN_ADDITIONAL_INFO = 1;
    private static final int FLAGS_REQUEST_OPLOCK = 2;
    private static final int FLAGS_REQUEST_BATCH_OPLOCK = 4;
    private static final int SHARING_COMPATIBILITY = 0;
    private static final int SHARING_DENY_READ_WRITE_EXECUTE = 16;
    private static final int SHARING_DENY_WRITE = 32;
    private static final int SHARING_DENY_READ_EXECUTE = 48;
    private static final int SHARING_DENY_NONE = 64;
    private static final int DO_NOT_CACHE = 4096;
    private static final int WRITE_THROUGH = 16384;
    private static final int OPEN_FN_CREATE = 16;
    private static final int OPEN_FN_FAIL_IF_EXISTS = 0;
    private static final int OPEN_FN_OPEN = 1;
    private static final int OPEN_FN_TRUNC = 2;
    private static final int BATCH_LIMIT = Config.getInt("jcifs.smb.client.OpenAndX.ReadAndX", 1);
    int flags;
    int desiredAccess;
    int searchAttributes;
    int fileAttributes;
    int creationTime;
    int openFunction;
    int allocationSize;

    SmbComOpenAndX(String fileName, int access, int flags, ServerMessageBlock andx) {
        super(andx);
        this.path = fileName;
        this.command = (byte)45;
        this.desiredAccess = access & 3;
        if (this.desiredAccess == 3) {
            this.desiredAccess = 2;
        }
        this.desiredAccess |= 0x40;
        this.desiredAccess &= 0xFFFFFFFE;
        this.searchAttributes = 22;
        this.fileAttributes = 0;
        this.openFunction = (flags & 0x40) == 64 ? ((flags & 0x10) == 16 ? 18 : 2) : ((flags & 0x10) == 16 ? ((flags & 0x20) == 32 ? 16 : 17) : 1);
    }

    @Override
    int getBatchLimit(byte command) {
        return command == 46 ? BATCH_LIMIT : 0;
    }

    @Override
    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SmbComOpenAndX.writeInt2(this.flags, dst, dstIndex);
        SmbComOpenAndX.writeInt2(this.desiredAccess, dst, dstIndex += 2);
        SmbComOpenAndX.writeInt2(this.searchAttributes, dst, dstIndex += 2);
        SmbComOpenAndX.writeInt2(this.fileAttributes, dst, dstIndex += 2);
        this.creationTime = 0;
        SmbComOpenAndX.writeInt4(this.creationTime, dst, dstIndex += 2);
        SmbComOpenAndX.writeInt2(this.openFunction, dst, dstIndex += 4);
        SmbComOpenAndX.writeInt4(this.allocationSize, dst, dstIndex += 2);
        dstIndex += 4;
        int i = 0;
        while (i < 8) {
            dst[dstIndex++] = 0;
            ++i;
        }
        return dstIndex - start;
    }

    @Override
    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        if (this.useUnicode) {
            dst[dstIndex++] = 0;
        }
        dstIndex += this.writeString(this.path, dst, dstIndex);
        return dstIndex - start;
    }

    @Override
    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return new String("SmbComOpenAndX[" + super.toString() + ",flags=0x" + Hexdump.toHexString(this.flags, 2) + ",desiredAccess=0x" + Hexdump.toHexString(this.desiredAccess, 4) + ",searchAttributes=0x" + Hexdump.toHexString(this.searchAttributes, 4) + ",fileAttributes=0x" + Hexdump.toHexString(this.fileAttributes, 4) + ",creationTime=" + new Date(this.creationTime) + ",openFunction=0x" + Hexdump.toHexString(this.openFunction, 2) + ",allocationSize=" + this.allocationSize + ",fileName=" + this.path + "]");
    }
}

