/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Random;
import jcifs.Config;
import jcifs.smb.SmbConstants;
import jcifs.util.DES;
import jcifs.util.HMACT64;
import jcifs.util.LogStream;
import org.bouncycastle.crypto.digests.MD4Digest;

public final class NtlmPasswordAuthentication
implements Principal,
Serializable {
    private static final int LM_COMPATIBILITY = Config.getInt("jcifs.smb.lmCompatibility", 0);
    private static final Random RANDOM = new Random();
    private static LogStream log = LogStream.getInstance();
    private static final byte[] S8 = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
    static String DEFAULT_DOMAIN;
    static String DEFAULT_USERNAME;
    static String DEFAULT_PASSWORD;
    static final String BLANK = "";
    static final NtlmPasswordAuthentication NULL;
    static final NtlmPasswordAuthentication GUEST;
    static final NtlmPasswordAuthentication DEFAULT;
    String domain;
    String username;
    String password;
    byte[] ansiHash;
    byte[] unicodeHash;
    boolean hashesExternal = false;
    byte[] clientChallenge = null;
    byte[] challenge = null;

    static {
        NULL = new NtlmPasswordAuthentication(BLANK, BLANK, BLANK);
        GUEST = new NtlmPasswordAuthentication("?", "GUEST", BLANK);
        DEFAULT = new NtlmPasswordAuthentication(null);
    }

    private static void E(byte[] key, byte[] data, byte[] e) {
        byte[] key7 = new byte[7];
        byte[] e8 = new byte[8];
        int i = 0;
        while (i < key.length / 7) {
            System.arraycopy(key, i * 7, key7, 0, 7);
            DES des = new DES(key7);
            des.encrypt(data, e8);
            System.arraycopy(e8, 0, e, i * 8, 8);
            ++i;
        }
    }

    static void initDefaults() {
        if (DEFAULT_DOMAIN != null) {
            return;
        }
        DEFAULT_DOMAIN = Config.getProperty("jcifs.smb.client.domain", "?");
        DEFAULT_USERNAME = Config.getProperty("jcifs.smb.client.username", "GUEST");
        DEFAULT_PASSWORD = Config.getProperty("jcifs.smb.client.password", BLANK);
    }

    public static byte[] getPreNTLMResponse(String password, byte[] challenge) {
        byte[] passwordBytes;
        byte[] p14 = new byte[14];
        byte[] p21 = new byte[21];
        byte[] p24 = new byte[24];
        try {
            passwordBytes = password.toUpperCase().getBytes(SmbConstants.OEM_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Try setting jcifs.encoding=US-ASCII", uee);
        }
        int passwordLength = passwordBytes.length;
        if (passwordLength > 14) {
            passwordLength = 14;
        }
        System.arraycopy(passwordBytes, 0, p14, 0, passwordLength);
        NtlmPasswordAuthentication.E(p14, S8, p21);
        NtlmPasswordAuthentication.E(p21, challenge, p24);
        return p24;
    }

    public static byte[] getNTLMResponse(String password, byte[] challenge) {
        byte[] p24;
        byte[] p21;
        block5: {
            byte[] uni;
            block4: {
                uni = null;
                p21 = new byte[21];
                p24 = new byte[24];
                try {
                    uni = password.getBytes("UnicodeLittleUnmarked");
                }
                catch (UnsupportedEncodingException uee) {
                    if (LogStream.level <= 0) break block4;
                    uee.printStackTrace(log);
                }
            }
            MD4Digest md4 = new MD4Digest();
            md4.update(uni, 0, uni.length);
            try {
                md4.doFinal(p21, 0);
            }
            catch (Exception ex) {
                if (LogStream.level <= 0) break block5;
                ex.printStackTrace(log);
            }
        }
        NtlmPasswordAuthentication.E(p21, challenge, p24);
        return p24;
    }

    public static byte[] getLMv2Response(String domain, String user, String password, byte[] challenge, byte[] clientChallenge) {
        try {
            byte[] hash = new byte[16];
            byte[] response = new byte[24];
            MD4Digest md4 = new MD4Digest();
            byte[] bytes = password.getBytes("UnicodeLittleUnmarked");
            md4.update(bytes, 0, bytes.length);
            byte[] digest = new byte[md4.getDigestSize()];
            md4.doFinal(digest, 0);
            HMACT64 hmac = new HMACT64(digest);
            hmac.update(user.toUpperCase().getBytes("UnicodeLittleUnmarked"));
            hmac.update(domain.toUpperCase().getBytes("UnicodeLittleUnmarked"));
            hmac = new HMACT64(hmac.digest());
            hmac.update(challenge);
            hmac.update(clientChallenge);
            hmac.digest(response, 0, 16);
            System.arraycopy(clientChallenge, 0, response, 16, 8);
            return response;
        }
        catch (Exception ex) {
            if (LogStream.level > 0) {
                ex.printStackTrace(log);
            }
            return null;
        }
    }

    public NtlmPasswordAuthentication(String userInfo) {
        this.password = null;
        this.username = null;
        this.domain = null;
        if (userInfo != null) {
            try {
                userInfo = NtlmPasswordAuthentication.unescape(userInfo);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            int end = userInfo.length();
            int i = 0;
            int u = 0;
            while (i < end) {
                char c = userInfo.charAt(i);
                if (c == ';') {
                    this.domain = userInfo.substring(0, i);
                    u = i + 1;
                } else if (c == ':') {
                    this.password = userInfo.substring(i + 1);
                    break;
                }
                ++i;
            }
            this.username = userInfo.substring(u, i);
        }
        NtlmPasswordAuthentication.initDefaults();
        if (this.domain == null) {
            this.domain = DEFAULT_DOMAIN;
        }
        if (this.username == null) {
            this.username = DEFAULT_USERNAME;
        }
        if (this.password == null) {
            this.password = DEFAULT_PASSWORD;
        }
    }

    public NtlmPasswordAuthentication(String domain, String username, String password) {
        this.domain = domain;
        this.username = username;
        this.password = password;
        NtlmPasswordAuthentication.initDefaults();
        if (domain == null) {
            this.domain = DEFAULT_DOMAIN;
        }
        if (username == null) {
            this.username = DEFAULT_USERNAME;
        }
        if (password == null) {
            this.password = DEFAULT_PASSWORD;
        }
    }

    public NtlmPasswordAuthentication(String domain, String username, byte[] challenge, byte[] ansiHash, byte[] unicodeHash) {
        if (domain == null || username == null || ansiHash == null || unicodeHash == null) {
            throw new IllegalArgumentException("External credentials cannot be null");
        }
        this.domain = domain;
        this.username = username;
        this.password = null;
        this.challenge = challenge;
        this.ansiHash = ansiHash;
        this.unicodeHash = unicodeHash;
        this.hashesExternal = true;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public String getName() {
        boolean d = this.domain.length() > 0 && !this.domain.equals("?");
        return d ? String.valueOf(this.domain) + "\\" + this.username : this.username;
    }

    public byte[] getAnsiHash(byte[] challenge) {
        if (this.hashesExternal) {
            return this.ansiHash;
        }
        switch (LM_COMPATIBILITY) {
            case 0: 
            case 1: {
                return NtlmPasswordAuthentication.getPreNTLMResponse(this.password, challenge);
            }
            case 2: {
                return NtlmPasswordAuthentication.getNTLMResponse(this.password, challenge);
            }
            case 3: 
            case 4: 
            case 5: {
                if (this.clientChallenge == null) {
                    this.clientChallenge = new byte[8];
                    RANDOM.nextBytes(this.clientChallenge);
                }
                return NtlmPasswordAuthentication.getLMv2Response(this.domain, this.username, this.password, challenge, this.clientChallenge);
            }
        }
        return NtlmPasswordAuthentication.getPreNTLMResponse(this.password, challenge);
    }

    public byte[] getUnicodeHash(byte[] challenge) {
        if (this.hashesExternal) {
            return this.unicodeHash;
        }
        switch (LM_COMPATIBILITY) {
            case 0: 
            case 1: 
            case 2: {
                return NtlmPasswordAuthentication.getNTLMResponse(this.password, challenge);
            }
            case 3: 
            case 4: 
            case 5: {
                return new byte[0];
            }
        }
        return NtlmPasswordAuthentication.getNTLMResponse(this.password, challenge);
    }

    public byte[] getUserSessionKey(byte[] challenge) {
        byte[] key;
        block3: {
            if (this.hashesExternal) {
                return null;
            }
            key = new byte[16];
            try {
                this.getUserSessionKey(challenge, key, 0);
            }
            catch (Exception ex) {
                if (LogStream.level <= 0) break block3;
                ex.printStackTrace(log);
            }
        }
        return key;
    }

    void getUserSessionKey(byte[] challenge, byte[] dest, int offset) throws Exception {
        if (this.hashesExternal) {
            return;
        }
        MD4Digest md4 = new MD4Digest();
        byte[] bytes = this.password.getBytes("UnicodeLittleUnmarked");
        md4.update(bytes, 0, bytes.length);
        switch (LM_COMPATIBILITY) {
            case 0: 
            case 1: 
            case 2: {
                this.redigest(dest, offset, md4);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (this.clientChallenge == null) {
                    this.clientChallenge = new byte[8];
                    RANDOM.nextBytes(this.clientChallenge);
                }
                byte[] digest = new byte[md4.getDigestSize()];
                md4.doFinal(digest, 0);
                HMACT64 hmac = new HMACT64(digest);
                hmac.update(this.username.toUpperCase().getBytes("UnicodeLittleUnmarked"));
                hmac.update(this.domain.toUpperCase().getBytes("UnicodeLittleUnmarked"));
                byte[] ntlmv2Hash = hmac.digest();
                hmac = new HMACT64(ntlmv2Hash);
                hmac.update(challenge);
                hmac.update(this.clientChallenge);
                HMACT64 userKey = new HMACT64(ntlmv2Hash);
                userKey.update(hmac.digest());
                userKey.digest(dest, offset, 16);
                break;
            }
            default: {
                this.redigest(dest, offset, md4);
            }
        }
    }

    private void redigest(byte[] dest, int offset, MD4Digest md4) {
        byte[] digest = new byte[md4.getDigestSize()];
        md4.doFinal(digest, 0);
        md4.reset();
        md4.update(digest, 0, digest.length);
        md4.doFinal(digest, 0);
        System.arraycopy(digest, 0, dest, offset, 16);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof NtlmPasswordAuthentication) {
            NtlmPasswordAuthentication ntlm = (NtlmPasswordAuthentication)obj;
            if (ntlm.domain.toUpperCase().equals(this.domain.toUpperCase()) && ntlm.username.toUpperCase().equals(this.username.toUpperCase())) {
                if (this.hashesExternal && ntlm.hashesExternal) {
                    return Arrays.equals(this.ansiHash, ntlm.ansiHash) && Arrays.equals(this.unicodeHash, ntlm.unicodeHash);
                }
                if (!this.hashesExternal && this.password.equals(ntlm.password)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getName().toUpperCase().hashCode();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    static String unescape(String str) throws NumberFormatException, UnsupportedEncodingException {
        byte[] b = new byte[1];
        if (str == null) {
            return null;
        }
        int len = str.length();
        char[] out = new char[len];
        int state = 0;
        int j = 0;
        int i = 0;
        while (i < len) {
            switch (state) {
                case 0: {
                    char ch = str.charAt(i);
                    if (ch == '%') {
                        state = 1;
                        break;
                    }
                    out[j++] = ch;
                    break;
                }
                case 1: {
                    b[0] = (byte)(Integer.parseInt(str.substring(i, i + 2), 16) & 0xFF);
                    out[j++] = new String(b, 0, 1, "ASCII").charAt(0);
                    ++i;
                    state = 0;
                }
            }
            ++i;
        }
        return new String(out, 0, j);
    }
}

