/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opensaml.xmlsec.encryption.impl;

import javax.annotation.Nonnull;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.xmlsec.encryption.IterationCount;
import org.opensaml.xmlsec.encryption.KeyLength;
import org.opensaml.xmlsec.encryption.PBKDF2Params;
import org.opensaml.xmlsec.encryption.PRF;
import org.opensaml.xmlsec.encryption.Salt;

/**
 * A thread-safe Unmarshaller for {@link org.opensaml.xmlsec.encryption.PBKDF2Params} objects.
 */
public class PBKDF2ParamsUnmarshaller extends AbstractXMLEncryptionUnmarshaller {

    /** {@inheritDoc} */
    protected void processChildElement(@Nonnull final XMLObject parentXMLObject,
            @Nonnull final XMLObject childXMLObject) throws UnmarshallingException {
        
        final PBKDF2Params params = (PBKDF2Params) parentXMLObject;
        
        if (childXMLObject instanceof Salt) {
            params.setSalt((Salt) childXMLObject);
        } else if (childXMLObject instanceof IterationCount) {
            params.setIterationCount((IterationCount) childXMLObject);
        } else if (childXMLObject instanceof KeyLength) {
            params.setKeyLength((KeyLength) childXMLObject);
        } else if (childXMLObject instanceof PRF) {
            params.setPRF((PRF) childXMLObject);
        } else {
            super.processChildElement(parentXMLObject, childXMLObject);
        }
    }

}