/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class WhitelistPredicate
implements Predicate<String> {
    @Nonnull
    @NonnullElements
    private Collection<String> whitelist;

    public WhitelistPredicate(@Nonnull Collection<String> algorithms) {
        this.whitelist = Set.copyOf((Collection)Constraint.isNotNull(algorithms, (String)"Whitelist may not be null"));
    }

    @Override
    public boolean test(@Nullable String input) {
        if (input == null) {
            throw new IllegalArgumentException("Algorithm URI to evaluate may not be null");
        }
        if (this.whitelist.isEmpty()) {
            return true;
        }
        return this.whitelist.contains(input);
    }
}

