/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.profile.saml.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.saml.saml2.core.impl.RequestAbstractTypeImpl;
import org.opensaml.xacml.ctx.RequestType;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;
import org.opensaml.xacml.profile.saml.ReferencedPoliciesType;
import org.opensaml.xacml.profile.saml.XACMLAuthzDecisionQueryType;

public class XACMLAuthzDecisionQueryTypeImpl
extends RequestAbstractTypeImpl
implements XACMLAuthzDecisionQueryType {
    private List<PolicyType> policies;
    private List<PolicySetType> policySets;
    private ReferencedPoliciesType referencedPolicies;
    private RequestType request;
    private XSBooleanValue inputContextOnly;
    private XSBooleanValue returnContext;
    private XSBooleanValue combinePolicies;

    protected XACMLAuthzDecisionQueryTypeImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
        this.setElementNamespacePrefix(namespacePrefix);
        this.policies = new XMLObjectChildrenList((XMLObject)this);
        this.policySets = new XMLObjectChildrenList((XMLObject)this);
    }

    public XSBooleanValue getCombinePoliciesXSBooleanValue() {
        return this.combinePolicies;
    }

    public XSBooleanValue getInputContextOnlyXSBooleanValue() {
        return this.inputContextOnly;
    }

    public List<XMLObject> getOrderedChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        if (super.getOrderedChildren() != null) {
            children.addAll(super.getOrderedChildren());
        }
        if (this.request != null) {
            children.add(this.request);
        }
        if (!this.policies.isEmpty()) {
            children.addAll(this.policies);
        }
        if (!this.policySets.isEmpty()) {
            children.addAll(this.policySets);
        }
        if (this.referencedPolicies != null) {
            children.add(this.referencedPolicies);
        }
        return Collections.unmodifiableList(children);
    }

    public RequestType getRequest() {
        return this.request;
    }

    public XSBooleanValue getReturnContextXSBooleanValue() {
        return this.returnContext;
    }

    public Boolean isCombinePolicies() {
        if (this.combinePolicies != null) {
            return this.combinePolicies.getValue();
        }
        return Boolean.TRUE;
    }

    public Boolean isInputContextOnly() {
        if (this.inputContextOnly != null) {
            return this.inputContextOnly.getValue();
        }
        return Boolean.FALSE;
    }

    public Boolean isReturnContext() {
        if (this.returnContext != null) {
            return this.returnContext.getValue();
        }
        return Boolean.FALSE;
    }

    public void setCombinePolicies(XSBooleanValue combinePolicies) {
        this.combinePolicies = (XSBooleanValue)this.prepareForAssignment(this.combinePolicies, combinePolicies);
    }

    public void setCombinePolicies(Boolean combinePolicies) {
        this.combinePolicies = combinePolicies != null ? (XSBooleanValue)this.prepareForAssignment(this.combinePolicies, new XSBooleanValue(combinePolicies, false)) : (XSBooleanValue)this.prepareForAssignment(this.combinePolicies, null);
    }

    public void setInputContextOnly(XSBooleanValue inputContextOnly) {
        this.inputContextOnly = (XSBooleanValue)this.prepareForAssignment(this.inputContextOnly, inputContextOnly);
    }

    public void setInputContextOnly(Boolean inputContextOnly) {
        this.inputContextOnly = inputContextOnly != null ? (XSBooleanValue)this.prepareForAssignment(this.inputContextOnly, new XSBooleanValue(inputContextOnly, false)) : (XSBooleanValue)this.prepareForAssignment(this.inputContextOnly, null);
    }

    public void setRequest(RequestType request) {
        this.request = (RequestType)this.prepareForAssignment((XMLObject)this.request, (XMLObject)request);
    }

    public void setReturnContext(XSBooleanValue returnContext) {
        this.returnContext = (XSBooleanValue)this.prepareForAssignment(this.returnContext, returnContext);
    }

    public void setReturnContext(Boolean returnContext) {
        this.returnContext = returnContext != null ? (XSBooleanValue)this.prepareForAssignment(this.returnContext, new XSBooleanValue(returnContext, false)) : (XSBooleanValue)this.prepareForAssignment(this.returnContext, null);
    }

    public List<PolicyType> getPolicies() {
        return this.policies;
    }

    public List<PolicySetType> getPolicySets() {
        return this.policySets;
    }

    public ReferencedPoliciesType getReferencedPolicies() {
        return this.referencedPolicies;
    }

    public void setReferencedPolicies(ReferencedPoliciesType policies) {
        this.referencedPolicies = (ReferencedPoliciesType)this.prepareForAssignment((XMLObject)this.referencedPolicies, (XMLObject)policies);
    }
}

