/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.testing;

import java.time.Instant;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Artifact;
import org.opensaml.saml.saml2.core.ArtifactResolve;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.IDPEntry;
import org.opensaml.saml.saml2.core.IDPList;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Scoping;
import org.opensaml.saml.saml2.core.Subject;

public class SAML2ActionTestingSupport {
    @Nonnull
    public static final String REQUEST_ID = "request";
    @Nonnull
    public static final String RESPONSE_ID = "response";
    @Nonnull
    public static final String ASSERTION_ID = "assertion";

    @Nonnull
    public static Response buildResponse() {
        SAMLObjectBuilder responseBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Response.DEFAULT_ELEMENT_NAME);
        Response response = (Response)responseBuilder.buildObject();
        response.setID("outbound");
        response.setIssueInstant(Instant.ofEpochMilli(0L));
        response.setVersion(SAMLVersion.VERSION_20);
        return response;
    }

    @Nonnull
    public static ArtifactResponse buildArtifactResponse() {
        SAMLObjectBuilder responseBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(ArtifactResponse.DEFAULT_ELEMENT_NAME);
        ArtifactResponse response = (ArtifactResponse)responseBuilder.buildObject();
        response.setID("outbound");
        response.setIssueInstant(Instant.ofEpochMilli(0L));
        response.setVersion(SAMLVersion.VERSION_20);
        return response;
    }

    @Nonnull
    public static LogoutRequest buildLogoutRequest(@Nullable NameID name) {
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder reqBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(LogoutRequest.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue("http://sp.example.org");
        LogoutRequest req = (LogoutRequest)reqBuilder.buildObject();
        req.setID(REQUEST_ID);
        req.setIssueInstant(Instant.ofEpochMilli(0L));
        req.setIssuer(issuer);
        req.setVersion(SAMLVersion.VERSION_20);
        if (name != null) {
            req.setNameID(name);
        }
        return req;
    }

    @Nonnull
    public static LogoutResponse buildLogoutResponse() {
        SAMLObjectBuilder responseBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(LogoutResponse.DEFAULT_ELEMENT_NAME);
        LogoutResponse response = (LogoutResponse)responseBuilder.buildObject();
        response.setID("outbound");
        response.setIssueInstant(Instant.ofEpochMilli(0L));
        response.setVersion(SAMLVersion.VERSION_20);
        return response;
    }

    @Nonnull
    public static Assertion buildAssertion() {
        SAMLObjectBuilder assertionBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Assertion.DEFAULT_ELEMENT_NAME);
        Assertion assertion = (Assertion)assertionBuilder.buildObject();
        assertion.setID(ASSERTION_ID);
        assertion.setIssueInstant(Instant.ofEpochMilli(0L));
        assertion.setVersion(SAMLVersion.VERSION_20);
        return assertion;
    }

    @Nonnull
    public static AuthnStatement buildAuthnStatement() {
        SAMLObjectBuilder statementBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(AuthnStatement.DEFAULT_ELEMENT_NAME);
        AuthnStatement statement = (AuthnStatement)statementBuilder.buildObject();
        statement.setAuthnInstant(Instant.ofEpochMilli(0L));
        return statement;
    }

    @Nonnull
    public static AttributeStatement buildAttributeStatement() {
        SAMLObjectBuilder statementBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(AttributeStatement.DEFAULT_ELEMENT_NAME);
        return (AttributeStatement)statementBuilder.buildObject();
    }

    @Nonnull
    public static Subject buildSubject(@Nullable String principalName) {
        SAMLObjectBuilder subjectBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Subject.DEFAULT_ELEMENT_NAME);
        Subject subject = (Subject)subjectBuilder.buildObject();
        if (principalName != null) {
            subject.setNameID(SAML2ActionTestingSupport.buildNameID(principalName));
        }
        return subject;
    }

    @Nonnull
    public static NameID buildNameID(@Nonnull @NotEmpty String principalName) {
        SAMLObjectBuilder nameIdBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(NameID.DEFAULT_ELEMENT_NAME);
        NameID nameId = (NameID)nameIdBuilder.buildObject();
        nameId.setValue(principalName);
        return nameId;
    }

    @Nonnull
    public static Issuer buildIssuer(@Nonnull @NotEmpty String entityID) {
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue(entityID);
        return issuer;
    }

    @Nonnull
    public static AttributeQuery buildAttributeQueryRequest(@Nullable Subject subject) {
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder queryBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(AttributeQuery.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue("http://sp.example.org");
        AttributeQuery query = (AttributeQuery)queryBuilder.buildObject();
        query.setID(REQUEST_ID);
        query.setIssueInstant(Instant.ofEpochMilli(0L));
        query.setIssuer(issuer);
        query.setVersion(SAMLVersion.VERSION_20);
        if (subject != null) {
            query.setSubject(subject);
        }
        return query;
    }

    @Nonnull
    public static AuthnRequest buildAuthnRequest() {
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder requestBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue("http://sp.example.org");
        AuthnRequest request = (AuthnRequest)requestBuilder.buildObject();
        request.setID(REQUEST_ID);
        request.setIssueInstant(Instant.ofEpochMilli(0L));
        request.setIssuer(issuer);
        request.setVersion(SAMLVersion.VERSION_20);
        return request;
    }

    @Nonnull
    public static Scoping buildScoping(@Nullable Integer count, @Nullable Set<String> idplist) {
        SAMLObjectBuilder scopingBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Scoping.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder idpListBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(IDPList.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder idpBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(IDPEntry.DEFAULT_ELEMENT_NAME);
        Scoping scoping = (Scoping)scopingBuilder.buildObject();
        scoping.setProxyCount(count);
        if (idplist != null && !idplist.isEmpty()) {
            IDPList idps = (IDPList)idpListBuilder.buildObject();
            for (String idp : idplist) {
                IDPEntry entry = (IDPEntry)idpBuilder.buildObject();
                entry.setProviderID(idp);
                idps.getIDPEntrys().add(entry);
            }
            scoping.setIDPList(idps);
        }
        return scoping;
    }

    @Nonnull
    public static ArtifactResolve buildArtifactResolve(@Nullable String artifact) {
        SAMLObjectBuilder requestBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(ArtifactResolve.DEFAULT_ELEMENT_NAME);
        ArtifactResolve request = (ArtifactResolve)requestBuilder.buildObject();
        request.setID(REQUEST_ID);
        request.setIssueInstant(Instant.ofEpochMilli(0L));
        request.setVersion(SAMLVersion.VERSION_11);
        if (artifact != null) {
            SAMLObjectBuilder artifactBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Artifact.DEFAULT_ELEMENT_NAME);
            Artifact art = (Artifact)artifactBuilder.buildObject();
            art.setValue(artifact);
            request.setArtifact(art);
        }
        return request;
    }
}

