/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.CookieManager;
import net.shibboleth.utilities.java.support.net.URISupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.security.DataExpiredException;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.opensaml.storage.AbstractMapBackedStorageService;
import org.opensaml.storage.MutableStorageRecord;
import org.opensaml.storage.RequestScopedStorageService;
import org.opensaml.storage.VersionMismatchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletRequestScopedStorageService
extends AbstractMapBackedStorageService
implements RequestScopedStorageService,
Filter {
    @Nonnull
    protected static final String CONTEXT_MAP_ATTRIBUTE = "org.opensaml.storage.impl.ServletRequestScopedStorageService.contextMap";
    @Nonnull
    protected static final String DIRTY_BIT_ATTRIBUTE = "org.opensaml.storage.impl.ServletRequestScopedStorageService.dirty";
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_COOKIE_NAME = "shib_idp_req_ss";
    @Nonnull
    private static final ReadWriteLock DUMMY_LOCK = new DummyReadWriteLock();
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ServletRequestScopedStorageService.class);
    @NonnullAfterInit
    private HttpServletRequest httpServletRequest;
    @NonnullAfterInit
    private HttpServletResponse httpServletResponse;
    @NonnullAfterInit
    private CookieManager cookieManager;
    @Nonnull
    @NotEmpty
    private String cookieName = "shib_idp_req_ss";
    @NonnullAfterInit
    private DataSealer dataSealer;

    public synchronized void setCleanupInterval(long interval) {
        super.setCleanupInterval(0L);
    }

    public void setHttpServletRequest(@Nonnull HttpServletRequest request) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.httpServletRequest = (HttpServletRequest)Constraint.isNotNull((Object)request, (String)"HttpServletRequest cannot be null");
    }

    public void setHttpServletResponse(@Nonnull HttpServletResponse response) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.httpServletResponse = (HttpServletResponse)Constraint.isNotNull((Object)response, (String)"HttpServletResponse cannot be null");
    }

    public void setCookieManager(@Nonnull CookieManager manager) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.cookieManager = (CookieManager)Constraint.isNotNull((Object)manager, (String)"CookieManager cannot be null");
    }

    public void setCookieName(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.cookieName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Cookie name cannot be null or empty");
    }

    public void setDataSealer(@Nonnull DataSealer sealer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpServletRequest == null || this.httpServletResponse == null) {
            throw new ComponentInitializationException("HttpServletRequest and HttpServletResponse must be set");
        }
        if (this.dataSealer == null || this.cookieManager == null) {
            throw new ComponentInitializationException("DataSealer and CookieManager must be set");
        }
    }

    public boolean create(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable Long expiration) throws IOException {
        if (super.create(context, key, value, expiration)) {
            this.setDirty(true);
            return true;
        }
        return false;
    }

    public void updateContextExpiration(@Nonnull @NotEmpty String context, @Nullable Long expiration) throws IOException {
        super.updateContextExpiration(context, expiration);
        this.setDirty(true);
    }

    public void deleteContext(@Nonnull @NotEmpty String context) throws IOException {
        super.deleteContext(context);
        this.setDirty(true);
    }

    public void reap(@Nonnull @NotEmpty String context) throws IOException {
        super.reap(context);
        this.setDirty(true);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Response was not an HttpServletResponse");
        }
        chain.doFilter(request, (ServletResponse)new OutputInterceptingHttpServletResponseProxy((HttpServletResponse)response));
    }

    protected void load() throws IOException {
        Map<String, Map<String, MutableStorageRecord>> contextMap = this.getContextMap();
        if (!contextMap.isEmpty()) {
            return;
        }
        this.log.trace("Loading storage state from cookie in current request");
        this.setDirty(false);
        Cookie[] cookies = this.httpServletRequest.getCookies();
        if (cookies == null) {
            return;
        }
        Optional cookie = Iterables.tryFind(Arrays.asList(cookies), (Predicate)new Predicate<Cookie>(){

            public boolean apply(@Nullable Cookie c) {
                return c != null && c.getName().equals(ServletRequestScopedStorageService.this.cookieName);
            }
        });
        if (!cookie.isPresent() || ((Cookie)cookie.get()).getValue() == null || ((Cookie)cookie.get()).getValue().isEmpty()) {
            return;
        }
        try {
            String decrypted = this.dataSealer.unwrap(URISupport.doURLDecode((String)((Cookie)cookie.get()).getValue()));
            this.log.trace("Data after decryption: {}", (Object)decrypted);
            JsonReader reader = Json.createReader((Reader)new StringReader(decrypted));
            JsonStructure st = reader.read();
            if (!(st instanceof JsonObject)) {
                throw new IOException("Found invalid data structure while parsing context map");
            }
            JsonObject obj = (JsonObject)st;
            for (Map.Entry context : obj.entrySet()) {
                if (((JsonValue)context.getValue()).getValueType() != JsonValue.ValueType.OBJECT) {
                    contextMap.clear();
                    throw new IOException("Found invalid data structure while parsing context map");
                }
                JsonObject contextRecords = (JsonObject)context.getValue();
                for (Map.Entry record : contextRecords.entrySet()) {
                    JsonObject fields = (JsonObject)record.getValue();
                    Long exp = null;
                    if (fields.containsKey((Object)"x")) {
                        exp = fields.getJsonNumber("x").longValueExact();
                    }
                    this.create((String)context.getKey(), (String)record.getKey(), fields.getString("v"), exp);
                }
            }
            this.setDirty(false);
        }
        catch (ArithmeticException | ClassCastException | NullPointerException | JsonException e) {
            contextMap.clear();
            this.setDirty(true);
            this.log.error("Exception while parsing context map", e);
            throw new IOException("Found invalid data structure while parsing context map", e);
        }
        catch (DataExpiredException e) {
            this.setDirty(true);
            this.log.debug("Secured data expired");
            return;
        }
        catch (DataSealerException e) {
            this.setDirty(true);
            this.log.error("Exception unwrapping secured data", (Throwable)e);
            throw new IOException("Exception unwrapping secured data", e);
        }
    }

    @Nullable
    protected void save() throws IOException {
        if (!this.isDirty()) {
            this.log.trace("Storage state has not been modified during request, save operation skipped");
            return;
        }
        this.log.trace("Saving updated storage data to cookie");
        Map<String, Map<String, MutableStorageRecord>> contextMap = this.getContextMap();
        if (contextMap.isEmpty()) {
            this.log.trace("Context map was empty, unsetting storage cookie");
            this.cookieManager.unsetCookie(this.cookieName);
            this.setDirty(false);
            return;
        }
        long exp = 0L;
        long now = System.currentTimeMillis();
        boolean empty = true;
        try {
            StringWriter sink = new StringWriter(128);
            JsonGenerator gen = Json.createGenerator((Writer)sink);
            gen.writeStartObject();
            for (Map.Entry<String, Map<String, MutableStorageRecord>> context : contextMap.entrySet()) {
                gen.writeStartObject(context.getKey());
                for (Map.Entry<String, MutableStorageRecord> entry : context.getValue().entrySet()) {
                    MutableStorageRecord record = entry.getValue();
                    Long recexp = record.getExpiration();
                    if (recexp != null && recexp <= now) continue;
                    empty = false;
                    gen.writeStartObject(entry.getKey()).write("v", record.getValue());
                    if (recexp != null) {
                        gen.write("x", record.getExpiration().longValue());
                        exp = Math.max(exp, recexp);
                    }
                    gen.writeEnd();
                }
                gen.writeEnd();
            }
            gen.writeEnd().close();
            if (empty) {
                this.log.trace("Context map was empty, unsetting storage cookie");
                this.cookieManager.unsetCookie(this.cookieName);
                this.setDirty(false);
                return;
            }
            String toEncrypt = sink.toString();
            this.log.trace("Size of data before encryption is {}", (Object)toEncrypt.length());
            this.log.trace("Data before encryption is {}", (Object)toEncrypt);
            try {
                String wrapped = this.dataSealer.wrap(toEncrypt, exp > 0L ? exp : now + 86400000L);
                this.log.trace("Size of data after encryption is {}", (Object)wrapped.length());
                this.cookieManager.addCookie(this.cookieName, URISupport.doURLEncode((String)wrapped));
                this.setDirty(false);
            }
            catch (DataSealerException e) {
                throw new IOException(e);
            }
        }
        catch (JsonException e) {
            this.log.error("JsonException while serializing context map", (Throwable)e);
            throw new IOException(e);
        }
    }

    @Nullable
    protected Integer updateImpl(@Nullable Integer version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nullable String value, @Nullable Long expiration) throws IOException, VersionMismatchException {
        Integer i = super.updateImpl(version, context, key, value, expiration);
        if (i != null) {
            this.setDirty(true);
        }
        return i;
    }

    protected boolean deleteImpl(@Nullable @Positive Integer version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException, VersionMismatchException {
        if (super.deleteImpl(version, context, key)) {
            this.setDirty(true);
            return true;
        }
        return false;
    }

    @Nullable
    protected TimerTask getCleanupTask() {
        return null;
    }

    @Nonnull
    @NonnullElements
    @Live
    protected Map<String, Map<String, MutableStorageRecord>> getContextMap() {
        Object contextMap = this.httpServletRequest.getAttribute(CONTEXT_MAP_ATTRIBUTE);
        if (contextMap != null) {
            return (Map)contextMap;
        }
        HashMap newMap = Maps.newHashMap();
        this.httpServletRequest.setAttribute(CONTEXT_MAP_ATTRIBUTE, (Object)newMap);
        try {
            this.load();
        }
        catch (IOException e) {
            this.setDirty(true);
            this.log.error("Error loading data from cookie, starting fresh", (Throwable)e);
        }
        return newMap;
    }

    @Nonnull
    protected ReadWriteLock getLock() {
        return DUMMY_LOCK;
    }

    private void setDirty(boolean flag) {
        if (flag) {
            this.httpServletRequest.setAttribute(DIRTY_BIT_ATTRIBUTE, (Object)Boolean.TRUE);
        } else {
            this.httpServletRequest.removeAttribute(DIRTY_BIT_ATTRIBUTE);
        }
    }

    private boolean isDirty() {
        Object dirty = this.httpServletRequest.getAttribute(DIRTY_BIT_ATTRIBUTE);
        if (dirty != null && dirty instanceof Boolean) {
            return (Boolean)dirty;
        }
        return false;
    }

    private static class DummyReadWriteLock
    implements ReadWriteLock {
        private static DummyLock lock;

        public DummyReadWriteLock() {
            lock = new DummyLock();
        }

        @Override
        public Lock readLock() {
            return lock;
        }

        @Override
        public Lock writeLock() {
            return lock;
        }

        private static class DummyLock
        implements Lock {
            private DummyLock() {
            }

            @Override
            public void lock() {
            }

            @Override
            public void lockInterruptibly() throws InterruptedException {
            }

            @Override
            public boolean tryLock() {
                return true;
            }

            @Override
            public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
                return true;
            }

            @Override
            public void unlock() {
            }

            @Override
            public Condition newCondition() {
                throw new UnsupportedOperationException("Conditions not supported");
            }
        }
    }

    private class OutputInterceptingHttpServletResponseProxy
    extends HttpServletResponseWrapper {
        public OutputInterceptingHttpServletResponseProxy(HttpServletResponse response) {
            super(response);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            ServletRequestScopedStorageService.this.save();
            return super.getOutputStream();
        }

        public PrintWriter getWriter() throws IOException {
            ServletRequestScopedStorageService.this.save();
            return super.getWriter();
        }

        public void sendError(int sc, String msg) throws IOException {
            ServletRequestScopedStorageService.this.save();
            super.sendError(sc, msg);
        }

        public void sendError(int sc) throws IOException {
            ServletRequestScopedStorageService.this.save();
            super.sendError(sc);
        }

        public void sendRedirect(String location) throws IOException {
            ServletRequestScopedStorageService.this.save();
            super.sendRedirect(location);
        }
    }
}

