/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.spring.httpclient;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.X509Credential;
import org.springframework.beans.factory.FactoryBean;

public class HttpClientSecurityParametersMergingFactoryBean
implements FactoryBean<HttpClientSecurityParameters> {
    @Nonnull
    @NonnullElements
    private List<HttpClientSecurityParameters> parameters = CollectionSupport.emptyList();

    public Class<?> getObjectType() {
        return HttpClientSecurityParameters.class;
    }

    @Nonnull
    @NonnullElements
    public List<HttpClientSecurityParameters> getParameters() {
        return this.parameters;
    }

    public void setParameters(@Nonnull @NonnullElements List<HttpClientSecurityParameters> input) {
        this.parameters = (List)Constraint.isNotNull(input, (String)"Input paramaters list may not be null");
    }

    @Nullable
    public HttpClientSecurityParameters getObject() throws Exception {
        if (this.parameters.isEmpty()) {
            return null;
        }
        if (this.parameters.size() == 1) {
            return this.parameters.get(0);
        }
        HttpClientSecurityParameters result = new HttpClientSecurityParameters();
        result.setCredentialsProvider((CredentialsProvider)this.parameters.stream().map(HttpClientSecurityParameters::getCredentialsProvider).filter(Objects::nonNull).findFirst().orElse(null));
        result.setPreemptiveBasicAuthMap((Map)this.parameters.stream().map(HttpClientSecurityParameters::getPreemptiveBasicAuthMap).filter(Objects::nonNull).findFirst().orElse(null));
        result.setAuthCache((AuthCache)this.parameters.stream().map(HttpClientSecurityParameters::getAuthCache).filter(Objects::nonNull).findFirst().orElse(null));
        result.setTLSTrustEngine((TrustEngine)this.parameters.stream().map(t -> t.getTLSTrustEngine()).filter(Objects::nonNull).findFirst().orElse(null));
        result.setTLSCriteriaSet((CriteriaSet)this.parameters.stream().map(HttpClientSecurityParameters::getTLSCriteriaSet).filter(Objects::nonNull).findFirst().orElse(null));
        result.setTLSProtocols((Collection)this.parameters.stream().map(HttpClientSecurityParameters::getTLSProtocols).filter(Objects::nonNull).findFirst().orElse(null));
        result.setTLSCipherSuites((Collection)this.parameters.stream().map(HttpClientSecurityParameters::getTLSCipherSuites).filter(Objects::nonNull).findFirst().orElse(null));
        result.setHostnameVerifier((HostnameVerifier)this.parameters.stream().map(HttpClientSecurityParameters::getHostnameVerifier).filter(Objects::nonNull).findFirst().orElse(null));
        result.setClientTLSCredential((X509Credential)this.parameters.stream().map(HttpClientSecurityParameters::getClientTLSCredential).filter(Objects::nonNull).findFirst().orElse(null));
        result.setServerTLSFailureFatal((Boolean)this.parameters.stream().map(HttpClientSecurityParameters::isServerTLSFailureFatal).filter(Objects::nonNull).findFirst().orElse(null));
        return result;
    }
}

