/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opensaml.soap.common;

import java.util.Set;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;

import org.opensaml.messaging.handler.MessageHandler;

/**
 * Interface for {@link MessageHandler}s that are specific to SOAP message processing.
 */
public interface SOAPHandler extends MessageHandler {
    
    /**
     * Get the set of SOAP header names that the handler
     * indicates it understands.
     * 
     * @return unmodifiable set of understood header names, possibly empty
     */
    @Nonnull public Set<QName> understandsHeaders();

}