/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.impl;

import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.security.x509.PKIXValidationInformation;

public class BasicPKIXValidationInformation
implements PKIXValidationInformation {
    private final Collection<X509Certificate> trustAnchors;
    private final Collection<X509CRL> trustedCRLs;
    private final Integer verificationDepth;

    public BasicPKIXValidationInformation(@Nullable Collection<X509Certificate> anchors, @Nullable Collection<X509CRL> crls, @Nonnull Integer depth) {
        this.verificationDepth = (Integer)Constraint.isNotNull((Object)depth, (String)"Verification depth cannot be null");
        this.trustAnchors = anchors;
        this.trustedCRLs = crls;
    }

    @Nullable
    public Collection<X509CRL> getCRLs() {
        return this.trustedCRLs;
    }

    @Nullable
    public Collection<X509Certificate> getCertificates() {
        return this.trustAnchors;
    }

    @Nonnull
    public Integer getVerificationDepth() {
        return this.verificationDepth;
    }
}

