/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.crypto;

import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.crypto.SigningUtil;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SigningUtilTest {
    private SecretKey secretKeyAES128;
    private KeyPair keyPairRSA;
    private Credential credAES;
    private Credential credRSA;
    private String data = "Hello, here is some secret data that is to be signed";
    private byte[] controlSignatureRSA;
    private byte[] controlSignatureHMAC;
    private String rsaJCAAlgorithm = "SHA1withRSA";
    private String hmacJCAAlgorithm = "HmacSHA1";

    @BeforeMethod
    protected void setUp() throws Exception {
        this.secretKeyAES128 = KeySupport.generateKey((String)"AES", (int)128, null);
        this.credAES = CredentialSupport.getSimpleCredential((SecretKey)this.secretKeyAES128);
        this.keyPairRSA = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        this.credRSA = CredentialSupport.getSimpleCredential((PublicKey)this.keyPairRSA.getPublic(), (PrivateKey)this.keyPairRSA.getPrivate());
        this.controlSignatureRSA = this.getControlSignature(this.data.getBytes(), this.keyPairRSA.getPrivate(), this.rsaJCAAlgorithm);
        Assert.assertNotNull((Object)this.controlSignatureRSA);
        Assert.assertTrue((this.controlSignatureRSA.length > 0 ? 1 : 0) != 0);
        this.controlSignatureHMAC = this.getControlSignature(this.data.getBytes(), this.secretKeyAES128, this.hmacJCAAlgorithm);
        Assert.assertNotNull((Object)this.controlSignatureHMAC);
        Assert.assertTrue((this.controlSignatureHMAC.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSigningWithPrivateKey() throws SecurityException {
        byte[] signature = SigningUtil.sign((Credential)this.credRSA, (String)this.rsaJCAAlgorithm, (boolean)false, (byte[])this.data.getBytes());
        Assert.assertNotNull((Object)signature);
        Assert.assertTrue((boolean)Arrays.equals(this.controlSignatureRSA, signature), (String)"Signature was not the expected value");
    }

    @Test
    public void testSigningWithHMAC() throws SecurityException {
        byte[] signature = SigningUtil.sign((Credential)this.credAES, (String)this.hmacJCAAlgorithm, (boolean)true, (byte[])this.data.getBytes());
        Assert.assertNotNull((Object)signature);
        Assert.assertTrue((boolean)Arrays.equals(this.controlSignatureHMAC, signature), (String)"Signature was not the expected value");
    }

    @Test
    public void testVerificationWithPublicKey() throws SecurityException, NoSuchAlgorithmException, NoSuchProviderException {
        Assert.assertTrue((boolean)SigningUtil.verify((Credential)this.credRSA, (String)this.rsaJCAAlgorithm, (boolean)false, (byte[])this.controlSignatureRSA, (byte[])this.data.getBytes()), (String)"Signature failed to verify, should have succeeded");
        KeyPair badKP = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        BasicCredential badCred = CredentialSupport.getSimpleCredential((PublicKey)badKP.getPublic(), (PrivateKey)badKP.getPrivate());
        Assert.assertFalse((boolean)SigningUtil.verify((Credential)badCred, (String)this.rsaJCAAlgorithm, (boolean)false, (byte[])this.controlSignatureRSA, (byte[])this.data.getBytes()), (String)"Signature verified successfully, should have failed due to wrong verification key");
        String tamperedData = this.data + "HAHA All your base are belong to us";
        Assert.assertFalse((boolean)SigningUtil.verify((Credential)this.credRSA, (String)this.rsaJCAAlgorithm, (boolean)false, (byte[])this.controlSignatureRSA, (byte[])tamperedData.getBytes()), (String)"Signature verified successfully, should have failed due to tampered data");
    }

    @Test
    public void testVerificationWithHMAC() throws SecurityException, NoSuchAlgorithmException, NoSuchProviderException {
        Assert.assertTrue((boolean)SigningUtil.verify((Credential)this.credAES, (String)this.hmacJCAAlgorithm, (boolean)true, (byte[])this.controlSignatureHMAC, (byte[])this.data.getBytes()), (String)"Signature failed to verify, should have succeeded");
        SecretKey badKey = KeySupport.generateKey((String)"AES", (int)128, null);
        BasicCredential badCred = CredentialSupport.getSimpleCredential((SecretKey)badKey);
        Assert.assertFalse((boolean)SigningUtil.verify((Credential)badCred, (String)this.hmacJCAAlgorithm, (boolean)true, (byte[])this.controlSignatureHMAC, (byte[])this.data.getBytes()), (String)"Signature verified successfully, should have failed due to wrong verification key");
        String tamperedData = this.data + "HAHA All your base are belong to us";
        Assert.assertFalse((boolean)SigningUtil.verify((Credential)this.credAES, (String)this.hmacJCAAlgorithm, (boolean)true, (byte[])this.controlSignatureHMAC, (byte[])tamperedData.getBytes()), (String)"Signature verified successfully, should have failed due to tampered data");
    }

    private byte[] getControlSignature(byte[] data1, SecretKey secretKey, String algorithm) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(algorithm);
        mac.init(this.secretKeyAES128);
        return mac.doFinal(data1);
    }

    private byte[] getControlSignature(byte[] data1, PrivateKey privateKey, String algorithm) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature sig = Signature.getInstance(algorithm);
        sig.initSign(privateKey);
        sig.update(data1);
        return sig.sign();
    }
}

