/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.ext.saml2mdattr.EntityAttributes;
import org.opensaml.saml.metadata.resolver.filter.AbstractMetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterContext;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.slf4j.Logger;

public class EntityAttributesFilter
extends AbstractMetadataFilter {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EntityAttributesFilter.class);
    @Nonnull
    private Multimap<Predicate<EntityDescriptor>, Attribute> applyMap;
    @Nullable
    private Predicate<Attribute> attributeFilter;
    @Nonnull
    private final SAMLObjectBuilder<Extensions> extBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Extensions.DEFAULT_ELEMENT_NAME);
    @Nonnull
    private final SAMLObjectBuilder<EntityAttributes> entityAttributesBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(EntityAttributes.DEFAULT_ELEMENT_NAME);

    public EntityAttributesFilter() {
        this.applyMap = ArrayListMultimap.create();
    }

    public void setRules(@Nonnull Map<Predicate<EntityDescriptor>, Collection<Attribute>> rules) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(rules, (String)"Rules map cannot be null");
        this.applyMap = ArrayListMultimap.create((int)rules.size(), (int)1);
        for (Map.Entry<Predicate<EntityDescriptor>, Collection<Attribute>> entry : rules.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.applyMap.putAll(entry.getKey(), List.copyOf(entry.getValue()));
        }
    }

    public void setAttributeFilter(@Nullable Predicate<Attribute> condition) {
        this.checkSetterPreconditions();
        this.attributeFilter = condition;
    }

    @Nullable
    public XMLObject filter(@Nullable XMLObject metadata, @Nonnull MetadataFilterContext context) throws FilterException {
        this.checkComponentActive();
        if (metadata == null) {
            return null;
        }
        if (metadata instanceof EntitiesDescriptor) {
            this.filterEntitiesDescriptor((EntitiesDescriptor)metadata);
        } else {
            this.filterEntityDescriptor((EntityDescriptor)metadata);
        }
        return metadata;
    }

    protected void filterEntityDescriptor(@Nonnull EntityDescriptor descriptor) {
        if (this.attributeFilter != null) {
            this.applyFilter(descriptor);
        }
        for (Map.Entry entry : this.applyMap.asMap().entrySet()) {
            List entityAttributesCollection;
            if (((Collection)entry.getValue()).isEmpty() || !((Predicate)entry.getKey()).test(descriptor)) continue;
            Extensions extensions = descriptor.getExtensions();
            if (extensions == null) {
                extensions = (Extensions)this.extBuilder.buildObject();
                descriptor.setExtensions(extensions);
            }
            if ((entityAttributesCollection = extensions.getUnknownXMLObjects(EntityAttributes.DEFAULT_ELEMENT_NAME)).isEmpty()) {
                entityAttributesCollection.add(this.entityAttributesBuilder.buildObject());
            }
            EntityAttributes entityAttributes = (EntityAttributes)entityAttributesCollection.iterator().next();
            assert (entityAttributes != null);
            ((Collection)entry.getValue()).forEach(a -> this.addEntityAttribute(descriptor, entityAttributes, (Attribute)a));
        }
    }

    protected void filterEntitiesDescriptor(@Nonnull EntitiesDescriptor descriptor) {
        for (EntitiesDescriptor group : descriptor.getEntitiesDescriptors()) {
            assert (group != null);
            this.filterEntitiesDescriptor(group);
        }
        for (EntityDescriptor entity : descriptor.getEntityDescriptors()) {
            assert (entity != null);
            this.filterEntityDescriptor(entity);
        }
    }

    private void addEntityAttribute(@Nonnull EntityDescriptor descriptor, @Nonnull EntityAttributes container, @Nonnull Attribute input) {
        Attribute toMutate = null;
        for (Attribute attribute : container.getAttributes()) {
            if (!Objects.equals(input.getName(), attribute.getName())) continue;
            String format1 = input.getNameFormat();
            String format2 = attribute.getNameFormat();
            if ("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified".equals(format1)) {
                format1 = null;
            }
            if ("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified".equals(format2)) {
                format2 = null;
            }
            if (!Objects.equals(format1, format2)) continue;
            toMutate = attribute;
            break;
        }
        if (toMutate != null) {
            for (XMLObject newValue : input.getAttributeValues()) {
                assert (newValue != null);
                try {
                    this.log.info("Adding value to existing EntityAttribute ({}) on EntityDescriptor ({})", (Object)input.getName(), (Object)descriptor.getEntityID());
                    toMutate.getAttributeValues().add(XMLObjectSupport.cloneXMLObject((XMLObject)newValue));
                }
                catch (MarshallingException | UnmarshallingException e) {
                    this.log.error("Error cloning AttributeValue", e);
                }
            }
        } else {
            try {
                this.log.info("Adding new EntityAttribute ({}) to EntityDescriptor ({})", (Object)input.getName(), (Object)descriptor.getEntityID());
                container.getAttributes().add((Attribute)XMLObjectSupport.cloneXMLObject((XMLObject)input));
            }
            catch (MarshallingException | UnmarshallingException e) {
                this.log.error("Error cloning Attribute", e);
            }
        }
    }

    private void applyFilter(@Nonnull EntityDescriptor descriptor) {
        List entityAttributesCollection;
        Extensions ext = descriptor.getExtensions();
        if (ext != null && !(entityAttributesCollection = ext.getUnknownXMLObjects(EntityAttributes.DEFAULT_ELEMENT_NAME)).isEmpty()) {
            EntityAttributes entityAttributes = (EntityAttributes)entityAttributesCollection.iterator().next();
            List attributes = entityAttributes.getEntityAttributesChildren();
            Iterator iter = attributes.iterator();
            while (iter.hasNext()) {
                SAMLObject attribute = (SAMLObject)iter.next();
                if (!(attribute instanceof Attribute)) continue;
                assert (this.attributeFilter != null);
                if (this.attributeFilter.test((Attribute)attribute)) continue;
                this.log.warn("Filtering pre-existing attribute '{}' from entity '{}'", (Object)((Attribute)attribute).getName(), (Object)descriptor.getEntityID());
                iter.remove();
            }
        }
    }
}

