/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.AttributeConsumingServiceContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLAddAttributeConsumingServiceHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAMLAddAttributeConsumingServiceHandler.class);
    @Nonnull
    private Function<MessageContext, SAMLMetadataContext> metadataContextStrategy = Functions.compose((Function)new ChildContextLookup(SAMLMetadataContext.class), (Function)new ChildContextLookup(SAMLPeerEntityContext.class));
    @Nullable
    private AuthnRequest authnRequest;

    @Nonnull
    public Function<MessageContext, SAMLMetadataContext> getMetadataContextStrategy() {
        return this.metadataContextStrategy;
    }

    public void setMetadataContextStrategy(@Nonnull Function<MessageContext, SAMLMetadataContext> strategy) {
        this.metadataContextStrategy = (Function)Constraint.isNotNull(strategy, (String)"Metadata Strategy cannot be null");
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) {
        Object message = messageContext.getMessage();
        if (message instanceof AuthnRequest) {
            this.authnRequest = (AuthnRequest)message;
        }
        return true;
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        SAMLMetadataContext metadataContext = (SAMLMetadataContext)this.metadataContextStrategy.apply((Object)messageContext);
        if (metadataContext == null) {
            this.log.debug("{} No metadata context found, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        if (!(metadataContext.getRoleDescriptor() instanceof SPSSODescriptor)) {
            this.log.debug("{} Metadata context did not contain an SPSSODescriptor, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        SPSSODescriptor ssoDescriptor = (SPSSODescriptor)metadataContext.getRoleDescriptor();
        Integer acsIndex = this.authnRequest != null ? this.authnRequest.getAttributeConsumingServiceIndex() : null;
        AttributeConsumingService acs = null;
        if (null != acsIndex) {
            this.log.debug("{} AuthnRequest specified AttributeConsumingServiceIndex {}", (Object)this.getLogPrefix(), (Object)acsIndex);
            for (AttributeConsumingService acsEntry : ssoDescriptor.getAttributeConsumingServices()) {
                if (acsIndex.intValue() != acsEntry.getIndex()) continue;
                acs = acsEntry;
                break;
            }
        }
        if (null == acs) {
            this.log.debug("{} Selecting default AttributeConsumingService, if any", (Object)this.getLogPrefix());
            acs = ssoDescriptor.getDefaultAttributeConsumingService();
        }
        if (null != acs) {
            this.log.debug("{} Selected AttributeConsumingService with index {}", (Object)this.getLogPrefix(), (Object)acs.getIndex());
            ((AttributeConsumingServiceContext)metadataContext.getSubcontext(AttributeConsumingServiceContext.class, true)).setAttributeConsumingService(acs);
        } else {
            this.log.debug("{} No AttributeConsumingService selected", (Object)this.getLogPrefix());
        }
    }
}

